<?php

namespace App\Console\Commands;

use App\Services\NotificationService;
use Illuminate\Console\Command;

class SyncNotifications extends Command
{
    protected $signature = 'notifications:sync';
    protected $description = 'Sync all admin notifications from database';

    public function handle(NotificationService $notificationService): int
    {
        $this->info('Syncing notifications...');
        
        $notificationService->syncNotifications();
        
        $unreadCount = $notificationService->getUnreadCount();
        
        $this->info("✓ Notifications synced successfully!");
        $this->info("Unread notifications: {$unreadCount}");
        
        return Command::SUCCESS;
    }
}
