<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\HostelSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class HostelController extends Controller
{
    /**
     * Show the form for editing hostel settings.
     */
    public function edit()
    {
        $hostel = HostelSetting::getSetting();
        return view('admin.hostel.edit', compact('hostel'));
    }

    /**
     * Update the hostel settings.
     */
    public function update(Request $request)
    {
        $hostel = HostelSetting::getSetting();

        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['nullable', 'email', 'max:255'],
            'phone' => ['nullable', 'string', 'max:20'],
            'mobile' => ['nullable', 'string', 'max:20'],
            'address' => ['nullable', 'string'],
            'city' => ['nullable', 'string', 'max:255'],
            'state' => ['nullable', 'string', 'max:255'],
            'pincode' => ['nullable', 'string', 'max:10'],
            'website' => ['nullable', 'url', 'max:255'],
            'description' => ['nullable', 'string'],
            'facebook' => ['nullable', 'url', 'max:255'],
            'instagram' => ['nullable', 'url', 'max:255'],
            'twitter' => ['nullable', 'url', 'max:255'],
            'default_deposit_amount' => ['required', 'numeric', 'min:0'],
            'logo' => ['nullable', 'image', 'mimes:jpg,jpeg,png,gif', 'max:2048'],
        ]);

        $data = [
            'name' => $validated['name'],
            'email' => $validated['email'] ?? null,
            'phone' => $validated['phone'] ?? null,
            'mobile' => $validated['mobile'] ?? null,
            'address' => $validated['address'] ?? null,
            'city' => $validated['city'] ?? null,
            'state' => $validated['state'] ?? null,
            'pincode' => $validated['pincode'] ?? null,
            'website' => $validated['website'] ?? null,
            'description' => $validated['description'] ?? null,
            'facebook' => $validated['facebook'] ?? null,
            'instagram' => $validated['instagram'] ?? null,
            'twitter' => $validated['twitter'] ?? null,
            'default_deposit_amount' => $validated['default_deposit_amount'],
        ];

        // Handle logo upload
        if ($request->hasFile('logo')) {
            // Delete old logo if exists
            if ($hostel->logo) {
                Storage::disk('public')->delete($hostel->logo);
            }
            $data['logo'] = $request->file('logo')->store('hostel', 'public');
        }

        // Handle logo removal
        if ($request->input('logo_remove') === '1' && $hostel->logo) {
            Storage::disk('public')->delete($hostel->logo);
            $data['logo'] = null;
        }

        $hostel->update($data);

        return back()->with('success', 'Hostel settings updated successfully!');
    }
}
