<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Student;
use Illuminate\View\View;

class PoliceRecordController extends Controller
{
    /**
     * Police verification list: Active and Released students.
     */
    public function index(): View
    {
        $active = Student::query()
            ->with(['bed', 'room', 'floor', 'documents', 'agreementHistories'])
            ->where('status', Student::STATUS_ACTIVE)
            ->where('form_status', Student::FORM_STATUS_ACTIVE)
            ->orderBy('first_name')
            ->orderBy('last_name')
            ->get();

        $released = Student::query()
            ->with(['bed', 'agreementHistories'])
            ->where('status', Student::STATUS_LEFT)
            ->orderByDesc('updated_at')
            ->limit(200)
            ->get();

        return view('admin.police-records.index', [
            'active' => $active,
            'released' => $released,
        ]);
    }

    /**
     * Police verification form (Marathi) for print.
     */
    public function form(Student $student): View
    {
        $student->load(['bed', 'room', 'floor', 'documents', 'agreementHistories']);
        $latestAgreement = $student->agreementHistories->sortByDesc('to_date')->first();
        $firstAgreement = $student->agreementHistories->sortBy('from_date')->first();
        $admissionDate = $firstAgreement?->from_date;
        $leavingDate = $latestAgreement?->to_date;

        return view('admin.police-records.form', [
            'student' => $student,
            'admissionDate' => $admissionDate,
            'leavingDate' => $leavingDate,
        ]);
    }
}
