<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\DepositReturn;
use App\Models\Rent;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ReceiptBookController extends Controller
{
    /**
     * Rent Receipt Book: list rents with date + payment mode filters, total in footer.
     */
    public function rent(Request $request): View
    {
        $fromDate = $request->query('from_date');
        $toDate = $request->query('to_date');
        $paymentMode = $request->query('payment_mode');

        $query = Rent::query()
            ->with(['student.documents'])
            ->orderByDesc('paid_at')
            ->orderByDesc('id');

        if ($fromDate) {
            $query->whereDate('paid_at', '>=', $fromDate);
        }
        if ($toDate) {
            $query->whereDate('paid_at', '<=', $toDate);
        }
        if ($paymentMode !== null && $paymentMode !== '') {
            $query->where('payment_mode', $paymentMode);
        }

        $rents = $query->get();
        $total = $rents->sum('amount');
        $paymentModes = config('student_registration.payment_modes', []);

        return view('admin.receipts.rent', [
            'rents' => $rents,
            'total' => $total,
            'fromDate' => $fromDate,
            'toDate' => $toDate,
            'paymentMode' => $paymentMode,
            'paymentModes' => $paymentModes,
        ]);
    }

    /**
     * Deposit Receipt Book: list deposits with date + payment mode filters, total in footer.
     */
    public function deposit(Request $request): View
    {
        $fromDate = $request->query('from_date');
        $toDate = $request->query('to_date');
        $paymentMode = $request->query('payment_mode');

        $query = Deposit::query()
            ->with(['student.documents'])
            ->orderByDesc('actual_deposit_date')
            ->orderByDesc('id');

        if ($fromDate) {
            $query->whereDate('actual_deposit_date', '>=', $fromDate);
        }
        if ($toDate) {
            $query->whereDate('actual_deposit_date', '<=', $toDate);
        }
        if ($paymentMode !== null && $paymentMode !== '') {
            $query->where('payment_mode', $paymentMode);
        }

        $deposits = $query->get();
        $total = $deposits->sum('amount');
        $paymentModes = config('student_registration.payment_modes', []);

        return view('admin.receipts.deposit', [
            'deposits' => $deposits,
            'total' => $total,
            'fromDate' => $fromDate,
            'toDate' => $toDate,
            'paymentMode' => $paymentMode,
            'paymentModes' => $paymentModes,
        ]);
    }

    /**
     * Deposit Return Receipt Book: list deposit returns with date + payment mode filters, total in footer.
     */
    public function depositReturn(Request $request): View
    {
        $fromDate = $request->query('from_date');
        $toDate = $request->query('to_date');
        $paymentMode = $request->query('payment_mode');

        $query = DepositReturn::query()
            ->with(['student.documents'])
            ->orderByDesc('return_date')
            ->orderByDesc('id');

        if ($fromDate) {
            $query->whereDate('return_date', '>=', $fromDate);
        }
        if ($toDate) {
            $query->whereDate('return_date', '<=', $toDate);
        }
        if ($paymentMode !== null && $paymentMode !== '') {
            $query->where('payment_mode', $paymentMode);
        }

        $returns = $query->get();
        $total = $returns->sum('amount_returned');
        $paymentModes = config('student_registration.payment_modes', []);

        return view('admin.receipts.deposit-return', [
            'returns' => $returns,
            'total' => $total,
            'fromDate' => $fromDate,
            'toDate' => $toDate,
            'paymentMode' => $paymentMode,
            'paymentModes' => $paymentModes,
        ]);
    }
}
