<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsureOtpVerified
{
    public function handle(Request $request, Closure $next, string $guard = 'admin'): Response
    {
        if (!Auth::guard($guard)->check()) {
            return $next($request);
        }

        $sessionKey = 'otp_verified_' . $guard;
        if (session($sessionKey) !== true) {
            if ($request->expectsJson()) {
                return response()->json(['message' => 'OTP verification required.'], 403);
            }
            $loginRoute = $guard === 'admin' ? 'admin.verify-otp' : 'user.verify-otp';
            return redirect()->route($loginRoute);
        }

        return $next($request);
    }
}
