<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BankEntry extends Model
{
    public const TYPE_DEPOSIT_TO_BANK = 'deposit_to_bank';
    public const TYPE_WITHDRAW_FROM_BANK = 'withdraw_from_bank';

    protected $fillable = [
        'entry_date',
        'amount',
        'type',
        'payment_mode',
        'person_name',
        'transaction_id',
    ];

    protected function casts(): array
    {
        return [
            'entry_date' => 'date',
            'amount' => 'decimal:2',
        ];
    }
}
