<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Drawing extends Model
{
    public const TYPE_CREDIT = 'credit';
    public const TYPE_DEBIT = 'debit';

    protected $fillable = [
        'drawing_date',
        'amount',
        'type',
        'payment_mode',
        'transaction_id',
        'notes',
        'performed_by_id',
    ];

    protected function casts(): array
    {
        return [
            'drawing_date' => 'date',
            'amount' => 'decimal:2',
        ];
    }

    public function performedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'performed_by_id');
    }
}
