<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class ExpenseHead extends Model
{
    protected $fillable = ['name', 'slug'];

    public function expenses(): HasMany
    {
        return $this->hasMany(Expense::class, 'expense_head_id');
    }

    protected static function booted(): void
    {
        static::creating(function (ExpenseHead $head) {
            if (empty($head->slug)) {
                $head->slug = Str::slug($head->name);
            }
        });
    }
}
