<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Rent extends Model
{
    protected $fillable = [
        'student_id', 'period_from', 'period_to', 'due_date',
        'amount', 'balance_amount', 'advance_amount', 'receipt_no',
        'payment_mode', 'transaction_id', 'cheque_number', 'paid_at',
    ];

    protected function casts(): array
    {
        return [
            'period_from' => 'date',
            'period_to' => 'date',
            'due_date' => 'date',
            'amount' => 'decimal:2',
            'balance_amount' => 'decimal:2',
            'advance_amount' => 'decimal:2',
            'paid_at' => 'datetime',
        ];
    }

    public function student(): BelongsTo
    {
        return $this->belongsTo(Student::class);
    }
}
