<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WebsiteSetting extends Model
{
    protected $fillable = [
        'site_name',
        'site_logo',
        'site_logo_dark',
        'site_favicon',
        'primary_color',
        'secondary_color',
        'hero_title',
        'hero_subtitle',
        'hero_background_image',
        'hero_background_color',
        'hero_button_text',
        'hero_button_link',
        'about_title',
        'about_description',
        'stat_residents',
        'stat_experience',
        'meta_description',
        'meta_keywords',
        'custom_css',
        'custom_js',
    ];

    /**
     * Get the singleton website settings record.
     */
    public static function getSetting()
    {
        return static::firstOrCreate(
            ['id' => 1],
            [
                'hero_title' => 'Gurudev Hostel',
                'hero_subtitle' => 'Your home away from home',
            ]
        );
    }
}
