<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use App\Models\HostelSetting;
use Illuminate\Support\Facades\Vite;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Share hostel settings with all views
        View::composer('*', function ($view) {
            try {
                $hostelSettings = HostelSetting::getSetting();
                $view->with('hostelSettings', $hostelSettings);
            } catch (\Exception $e) {
                // If table doesn't exist yet (during migration), set null
                $view->with('hostelSettings', null);
            }
        });
    }
}
