<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Support\Facades\Route;

return Application::configure(basePath: dirname(__DIR__))
  ->withRouting(
    web: __DIR__.'/../routes/web.php',
    commands: __DIR__.'/../routes/console.php',
    health: '/up',
    then: function () {
      Route::middleware('web')
        ->prefix('admin')
        ->name('admin.')
        ->group(base_path('routes/admin.php'));

      Route::middleware('web')
        ->prefix('user')
        ->name('user.')
        ->group(base_path('routes/user.php'));
    },
  )
  ->withMiddleware(function (Middleware $middleware) {
    $middleware->alias([
      'auth.admin' => \App\Http\Middleware\AuthenticateAdmin::class,
      'auth.user' => \App\Http\Middleware\AuthenticateUser::class,
      'otp.verified' => \App\Http\Middleware\EnsureOtpVerified::class,
      'prevent.back.history' => \App\Http\Middleware\PreventBackHistory::class,
    ]);
  })
  ->withExceptions(function (Exceptions $exceptions) {
    //
  })->create();