<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('expense_head_id')->constrained('expense_heads')->cascadeOnDelete();
            $table->date('expense_date');
            $table->string('item_name');
            $table->decimal('amount', 12, 2);
            $table->string('payment_mode', 50);
            $table->string('transaction_id')->nullable();
            $table->string('file_path')->nullable();
            $table->timestamps();

            $table->index('expense_head_id');
            $table->index('expense_date');
            $table->index('payment_mode');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
