<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bank_entries', function (Blueprint $table) {
            $table->id();
            $table->date('entry_date');
            $table->decimal('amount', 12, 2);
            $table->string('type', 30); // deposit_to_bank, withdraw_from_bank
            $table->string('payment_mode', 50)->nullable();
            $table->string('person_name')->nullable();
            $table->string('transaction_id')->nullable();
            $table->timestamps();

            $table->index('entry_date');
            $table->index('type');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bank_entries');
    }
};
