<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('website_features', function (Blueprint $table) {
            $table->id();
            $table->string('icon')->default('ri-shield-check-line');
            $table->string('title');
            $table->text('description');
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Insert default features
        $features = [
            ['icon' => 'ri-shield-check-line', 'title' => '24/7 Security', 'description' => 'Round the clock security with CCTV surveillance for your safety', 'sort_order' => 1],
            ['icon' => 'ri-wifi-line', 'title' => 'High-Speed WiFi', 'description' => 'Free high-speed internet access throughout the hostel premises', 'sort_order' => 2],
            ['icon' => 'ri-restaurant-line', 'title' => 'Quality Food', 'description' => 'Hygienic and nutritious meals prepared daily with care', 'sort_order' => 3],
            ['icon' => 'ri-home-heart-line', 'title' => 'Comfortable Rooms', 'description' => 'Well-furnished rooms with all essential amenities', 'sort_order' => 4],
            ['icon' => 'ri-lightbulb-flash-line', 'title' => 'Power Backup', 'description' => 'Uninterrupted power supply with backup generators', 'sort_order' => 5],
            ['icon' => 'ri-hand-sanitizer-line', 'title' => 'Clean Environment', 'description' => 'Daily cleaning and sanitation for healthy living', 'sort_order' => 6],
            ['icon' => 'ri-customer-service-2-line', 'title' => '24/7 Support', 'description' => 'Always available staff to assist with any concerns', 'sort_order' => 7],
            ['icon' => 'ri-book-open-line', 'title' => 'Study Room', 'description' => 'Dedicated quiet spaces for focused studying', 'sort_order' => 8],
        ];

        foreach ($features as $feature) {
            $feature['created_at'] = now();
            $feature['updated_at'] = now();
            DB::table('website_features')->insert($feature);
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('website_features');
    }
};
