<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_menus', function (Blueprint $table) {
            $table->id();
            $table->string('title', 255)->comment('Menu identifier/key');
            $table->string('title_text', 255)->nullable()->comment('Display text for menu');
            $table->enum('link_type', ['custom_page', 'link_url', 'placeholder'])->comment('Type of link');
            $table->string('custom_page', 255)->nullable()->comment('Custom page slug reference');
            $table->text('link_url')->nullable()->comment('External URL');
            $table->integer('order')->default(1)->comment('Display order position');
            $table->longText('submenus')->nullable()->comment('JSON storage for unlimited nested submenus');
            $table->boolean('is_active')->default(1)->comment('Active/inactive status');
            $table->timestamps();

            // Add indexes
            $table->index('order');
            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_menus');
    }
};
