<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('website_settings', function (Blueprint $table) {
            $table->string('site_name')->nullable()->after('id')->comment('Website/Hostel name');
            $table->string('site_logo')->nullable()->after('site_name')->comment('Logo image path');
            $table->string('site_logo_dark')->nullable()->after('site_logo')->comment('Dark mode logo image path');
            $table->string('site_favicon')->nullable()->after('site_logo_dark')->comment('Favicon image path');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('website_settings', function (Blueprint $table) {
            $table->dropColumn(['site_name', 'site_logo', 'site_logo_dark', 'site_favicon']);
        });
    }
};
