<?php

namespace Database\Seeders;

use App\Models\CustomPageModel;
use Illuminate\Database\Seeder;

class CustomPagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $customPages = [
            [
                'page_id' => 'about-us',
                'page_slug' => 'about-us',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'page_id' => 'contact-us',
                'page_slug' => 'contact-us',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($customPages as $page) {
            CustomPageModel::updateOrCreate(
                ['page_slug' => $page['page_slug']],
                $page
            );
        }

        $this->command->info('Custom pages seeded successfully!');
    }
}
