<?php

namespace Database\Seeders;

use App\Models\Menu;
use Illuminate\Database\Seeder;

class MenusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $menus = [
            [
                'title' => 'dashboard',
                'title_text' => 'Dashboard',
                'link_type' => 'custom_page',
                'custom_page' => 'dashboard',
                'link_url' => null,
                'order' => 1,
                'submenus' => json_encode([]),
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'content_management',
                'title_text' => 'Content Management',
                'link_type' => 'placeholder',
                'custom_page' => null,
                'link_url' => null,
                'order' => 2,
                'submenus' => json_encode([
                    [
                        'title' => 'custom_pages',
                        'title_text' => 'Custom Pages',
                        'link_type' => 'custom_page',
                        'custom_page' => 'custom_pages',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                    [
                        'title' => 'email_templates',
                        'title_text' => 'Email Templates',
                        'link_type' => 'custom_page',
                        'custom_page' => 'email_templates',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                    [
                        'title' => 'menu_management',
                        'title_text' => 'Menu Management',
                        'link_type' => 'custom_page',
                        'custom_page' => 'menu_management',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                ]),
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'user_management',
                'title_text' => 'User Management',
                'link_type' => 'placeholder',
                'custom_page' => null,
                'link_url' => null,
                'order' => 3,
                'submenus' => json_encode([
                    [
                        'title' => 'users',
                        'title_text' => 'All Users',
                        'link_type' => 'custom_page',
                        'custom_page' => 'users',
                        'link_url' => null,
                        'submenus' => [
                            [
                                'title' => 'create_user',
                                'title_text' => 'Create User',
                                'link_type' => 'custom_page',
                                'custom_page' => 'create_user',
                                'link_url' => null,
                                'submenus' => [],
                            ],
                        ],
                    ],
                    [
                        'title' => 'user_roles',
                        'title_text' => 'User Roles',
                        'link_type' => 'custom_page',
                        'custom_page' => 'user_roles',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                    [
                        'title' => 'permissions',
                        'title_text' => 'Permissions',
                        'link_type' => 'custom_page',
                        'custom_page' => 'permissions',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                ]),
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'ecommerce',
                'title_text' => 'E-Commerce',
                'link_type' => 'placeholder',
                'custom_page' => null,
                'link_url' => null,
                'order' => 4,
                'submenus' => json_encode([
                    [
                        'title' => 'store',
                        'title_text' => 'Store',
                        'link_type' => 'custom_page',
                        'custom_page' => 'store',
                        'link_url' => null,
                        'submenus' => [
                            [
                                'title' => 'products',
                                'title_text' => 'Products',
                                'link_type' => 'custom_page',
                                'custom_page' => 'products',
                                'link_url' => null,
                                'submenus' => [],
                            ],
                        ],
                    ],
                    [
                        'title' => 'invoices',
                        'title_text' => 'Invoices',
                        'link_type' => 'custom_page',
                        'custom_page' => 'invoices',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                    [
                        'title' => 'orders',
                        'title_text' => 'Orders',
                        'link_type' => 'custom_page',
                        'custom_page' => 'orders',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                ]),
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'settings',
                'title_text' => 'Settings',
                'link_type' => 'placeholder',
                'custom_page' => null,
                'link_url' => null,
                'order' => 5,
                'submenus' => json_encode([
                    [
                        'title' => 'api_configuration',
                        'title_text' => 'API Configuration',
                        'link_type' => 'custom_page',
                        'custom_page' => 'api_configuration',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                    [
                        'title' => 'website_configuration',
                        'title_text' => 'Website Configuration',
                        'link_type' => 'custom_page',
                        'custom_page' => 'website_configuration',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                ]),
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'events_academy',
                'title_text' => 'Events & Academy',
                'link_type' => 'placeholder',
                'custom_page' => null,
                'link_url' => null,
                'order' => 6,
                'submenus' => json_encode([
                    [
                        'title' => 'events',
                        'title_text' => 'Events',
                        'link_type' => 'custom_page',
                        'custom_page' => 'events',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                    [
                        'title' => 'courses',
                        'title_text' => 'Courses',
                        'link_type' => 'custom_page',
                        'custom_page' => 'courses',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                    [
                        'title' => 'quizzes',
                        'title_text' => 'Quizzes',
                        'link_type' => 'custom_page',
                        'custom_page' => 'quizzes',
                        'link_url' => null,
                        'submenus' => [],
                    ],
                ]),
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'title' => 'external_link',
                'title_text' => 'External Documentation',
                'link_type' => 'link_url',
                'custom_page' => null,
                'link_url' => 'https://docs.example.com',
                'order' => 7,
                'submenus' => json_encode([]),
                'is_active' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($menus as $menu) {
            Menu::updateOrCreate(
                ['title' => $menu['title']],
                $menu
            );
        }

        $this->command->info('Menus seeded successfully!');
    }
}
