@extends('layouts/contentNavbarLayout')

@section('title', 'Renew Agreement')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Renew Agreement</h4>
        <a href="{{ route('admin.agreements.index', ['student_id' => $student->id]) }}" class="btn btn-outline-secondary"><i class="ri-arrow-left-line me-1"></i>Back</a>
    </div>

    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.agreements.index') }}">View Agreement</a></li>
            <li class="breadcrumb-item active">Renew — {{ $student->full_name }}</li>
        </ol>
    </nav>

    <div class="card">
        <div class="card-header">
            <h5 class="card-title mb-0">Increase stay — {{ $student->full_name }}</h5>
        </div>
        <div class="card-body">
            <p class="text-muted">Current leaving date: <strong>{{ $currentToDate?->format('d/m/Y') ?? '—' }}</strong></p>
            <form action="{{ route('admin.agreements.renew.store', $student) }}" method="POST">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Increase To Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('increase_to_date') is-invalid @enderror" name="increase_to_date" value="{{ old('increase_to_date') }}" min="{{ date('Y-m-d') }}" required>
                        @error('increase_to_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12">
                        <label class="form-label">Remark (optional)</label>
                        <textarea class="form-control @error('remark') is-invalid @enderror" name="remark" rows="2" placeholder="e.g. Student requested 1-month extension">{{ old('remark') }}</textarea>
                        @error('remark')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary"><i class="ri-check-line me-1"></i>Renew Agreement</button>
                        <a href="{{ route('admin.agreements.index', ['student_id' => $student->id]) }}" class="btn btn-outline-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
