@extends('layouts/contentNavbarLayout')

@section('title', 'Enquiry View')

@section('vendor-style')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
.enquiry-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
.text-truncate-150 { max-width: 150px; }
.text-truncate-180 { max-width: 180px; }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Enquiry View</h4>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addEnquiryModal"><i class="ri-add-line me-1"></i>Add Enquiry</button>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    {{-- Filters --}}
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" action="{{ route('admin.enquiries.index') }}" id="enquiryFilterForm" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ $fromDate ?? '' }}" id="filterFromDate">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ $toDate ?? '' }}" id="filterToDate">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select class="form-select" name="status" id="filterStatus">
                        <option value="">All</option>
                        <option value="pending" {{ ($status ?? '') === 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="check" {{ ($status ?? '') === 'check' ? 'selected' : '' }}>Checked</option>
                        <option value="delete" {{ ($status ?? '') === 'delete' ? 'selected' : '' }}>Deleted</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    <a href="{{ route('admin.enquiries.index') }}" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table enquiry-table table-hover" id="enquiriesTable">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Name</th>
                            <th>Mobile</th>
                            <th>College/Class</th>
                            <th>Address</th>
                            <th>Message</th>
                            <th>Status</th>
                            <th>Remark</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="enquiryTableBody">
                        @include('admin.enquiries._table_body', ['enquiries' => $enquiries])
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

{{-- Add Enquiry Modal --}}
<div class="modal fade" id="addEnquiryModal" tabindex="-1" aria-labelledby="addEnquiryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.enquiries.store') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="addEnquiryModalLabel">Add New Enquiry</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required>
                        @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Mobile <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('mobile') is-invalid @enderror" name="mobile" value="{{ old('mobile') }}" required>
                        @error('mobile')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">College / Class</label>
                        <input type="text" class="form-control" name="class" value="{{ old('class') }}" placeholder="e.g. FY B.Com">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Address</label>
                        <input type="text" class="form-control" name="address" value="{{ old('address') }}" placeholder="Locality, city">
                    </div>
                    <div class="mb-0">
                        <label class="form-label">Message</label>
                        <textarea class="form-control" name="message" rows="3" placeholder="Requirements or questions">{{ old('message') }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Enquiry</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- Remark Modal (one, dynamic form action) --}}
<div class="modal fade" id="remarkModal" tabindex="-1" aria-labelledby="remarkModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="remarkForm" method="POST" action="">
                @csrf
                <input type="hidden" name="from_date" id="remarkFormFromDate" value="{{ request('from_date') }}">
                <input type="hidden" name="to_date" id="remarkFormToDate" value="{{ request('to_date') }}">
                <input type="hidden" name="status" id="remarkFormStatus" value="{{ request('status') }}">
                <div class="modal-header">
                    <h5 class="modal-title" id="remarkModalLabel">Add Remark</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="text-muted small mb-2">Adding a remark will mark this enquiry as <strong>Checked</strong>.</p>
                    <div class="mb-0">
                        <label class="form-label">Remark <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="remark" rows="3" required placeholder="e.g. Called, requested callback on Monday"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Add Remark</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('vendor-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
@endsection

@section('page-script')
<script>
(function() {
    // Initialize DataTable
    var table = $('#enquiriesTable');
    if (table.find('tbody tr').length > 0 && !table.find('tbody tr td').first().attr('colspan')) {
        table.DataTable({
            order: [[0, 'desc']], // Sort by Date descending
            pageLength: 25,
            language: {
                search: "Search:",
                lengthMenu: "Show _MENU_ entries",
                info: "Showing _START_ to _END_ of _TOTAL_ enquiries",
                infoEmpty: "No enquiries available",
                infoFiltered: "(filtered from _MAX_ total enquiries)"
            },
            columnDefs: [
                { orderable: false, targets: -1 } // Disable sorting on Actions column
            ]
        });
    }
    
    var remarkModal = document.getElementById('remarkModal');
    if (remarkModal) {
        remarkModal.addEventListener('show.bs.modal', function(ev) {
            var btn = ev.relatedTarget;
            if (!btn) return;
            var id = btn.getAttribute('data-enquiry-id');
            var name = btn.getAttribute('data-enquiry-name') || '';
            var form = document.getElementById('remarkForm');
            var baseUrl = @json(url('/admin/enquiries'));
            if (form && id) {
                form.action = baseUrl + '/' + id + '/remark';
                document.getElementById('remarkModalLabel').textContent = 'Add Remark — ' + (name || 'Enquiry #' + id);
                var fromEl = document.getElementById('remarkFormFromDate');
                var toEl = document.getElementById('remarkFormToDate');
                var statusEl = document.getElementById('remarkFormStatus');
                var filterFrom = document.getElementById('filterFromDate');
                var filterTo = document.getElementById('filterToDate');
                var filterStatus = document.getElementById('filterStatus');
                if (fromEl && filterFrom) fromEl.value = filterFrom.value;
                if (toEl && filterTo) toEl.value = filterTo.value;
                if (statusEl && filterStatus) statusEl.value = filterStatus.value;
            }
        });
    }

    // Optional: AJAX filter (submit form via fetch and replace tbody)
    var filterForm = document.getElementById('enquiryFilterForm');
    if (filterForm && typeof fetch !== 'undefined') {
        filterForm.addEventListener('submit', function(ev) {
            if (ev.target.getAttribute('data-ajax') === '1') {
                ev.preventDefault();
                var formData = new FormData(filterForm);
                var params = new URLSearchParams(formData).toString();
                fetch(@json(route('admin.enquiries.index')) + '?' + params, {
                    headers: { 'X-Requested-With': 'XMLHttpRequest', 'Accept': 'application/json' }
                }).then(function(r) { return r.json(); }).then(function(data) {
                    var tbody = document.getElementById('enquiryTableBody');
                    if (tbody && data.html) tbody.innerHTML = data.html;
                });
            }
        });
    }
})();
</script>
@endsection
