<div class="modal fade" id="returnModal{{ $leave->id }}" tabindex="-1" aria-labelledby="returnModalLabel{{ $leave->id }}" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('admin.leaves.return.store', $leave) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="returnModalLabel{{ $leave->id }}">Student Return — {{ $leave->student->full_name }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="text-muted small">Leave: {{ $leave->from_date->format('d/m/Y') }} – {{ $leave->to_date->format('d/m/Y') }}</p>
                    <div class="mb-3">
                        <label class="form-label">Return Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('return_date') is-invalid @enderror" name="return_date" value="{{ old('return_date', $leave->to_date->format('Y-m-d')) }}" min="{{ $leave->from_date->format('Y-m-d') }}" required>
                        @error('return_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Record Return</button>
                </div>
            </form>
        </div>
    </div>
</div>
