@extends('layouts/contentNavbarLayout')

@section('title', 'Add Bed')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">Add Bed</h4>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if($rooms->isEmpty())
        <div class="alert alert-warning">
            No rooms found. Please <a href="{{ route('admin.rooms.create') }}">create a room</a> first.
        </div>
    @else
    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.beds.store') }}" method="POST" id="bedForm">
                @csrf
                <input type="hidden" name="mode" id="mode" value="{{ old('mode', 'single') }}" />

                <div class="mb-4">
                    <label for="room_id" class="form-label">Room <span class="text-danger">*</span></label>
                    <select class="form-select @error('room_id') is-invalid @enderror" id="room_id" name="room_id" required>
                        <option value="">Select room</option>
                        @foreach ($floors as $floor)
                            <optgroup label="{{ $floor->name }}">
                                @foreach ($floor->rooms as $room)
                                    <option value="{{ $room->id }}" {{ old('room_id') == $room->id ? 'selected' : '' }}>{{ $room->name }}</option>
                                @endforeach
                            </optgroup>
                        @endforeach
                    </select>
                    @error('room_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-4">
                    <label class="form-label">Add beds</label>
                    <div class="d-flex gap-3 flex-wrap">
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="add_type" id="add_type_single" value="single" {{ old('mode', 'single') === 'single' ? 'checked' : '' }} />
                            <label class="form-check-label" for="add_type_single">Single bed</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="add_type" id="add_type_bulk" value="bulk" {{ old('mode') === 'bulk' ? 'checked' : '' }} />
                            <label class="form-check-label" for="add_type_bulk">Bulk beds</label>
                        </div>
                    </div>
                </div>

                <div id="single-fields" class="mb-4">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="name" class="form-label">Bed name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" placeholder="e.g. Bed 1" />
                            @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="rent_amount" class="form-label">Rent Amount (₹) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('rent_amount') is-invalid @enderror" id="rent_amount" name="rent_amount" value="{{ old('rent_amount') }}" min="0" step="0.01" placeholder="e.g. 5000" />
                            @error('rent_amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div id="bulk-fields" class="mb-4" style="display: none;">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="name_prefix" class="form-label">Name prefix</label>
                            <input type="text" class="form-control" id="name_prefix" name="name_prefix" value="{{ old('name_prefix', 'Bed') }}" placeholder="e.g. Bed" />
                            <div class="form-text">Beds will be named: prefix + number (e.g. Bed 1, Bed 2).</div>
                        </div>
                        <div class="col-md-4">
                            <label for="count" class="form-label">Number of beds <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('count') is-invalid @enderror" id="count" name="count" value="{{ old('count', 1) }}" min="1" max="50" />
                            @error('count')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-md-4">
                            <label for="bulk_rent_amount" class="form-label">Rent Amount (₹) <span class="text-danger">*</span></label>
                            <input type="number" class="form-control @error('bulk_rent_amount') is-invalid @enderror" id="bulk_rent_amount" name="bulk_rent_amount" value="{{ old('bulk_rent_amount') }}" min="0" step="0.01" placeholder="e.g. 5000" />
                            @error('bulk_rent_amount')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">Same rent will be applied to all beds.</div>
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">Add bed(s)</button>
                <a href="{{ route('admin.beds.index') }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
    @endif
</div>
@endsection

@section('page-script')
<script>
(function() {
    var addTypeSingle = document.getElementById('add_type_single');
    var addTypeBulk = document.getElementById('add_type_bulk');
    var singleFields = document.getElementById('single-fields');
    var bulkFields = document.getElementById('bulk-fields');
    var modeInput = document.getElementById('mode');
    var nameInput = document.getElementById('name');
    var countInput = document.getElementById('count');

    function toggle() {
        if (addTypeBulk.checked) {
            singleFields.style.display = 'none';
            bulkFields.style.display = 'block';
            modeInput.value = 'bulk';
            nameInput.removeAttribute('required');
            if (countInput) countInput.setAttribute('required', 'required');
        } else {
            singleFields.style.display = 'block';
            bulkFields.style.display = 'none';
            modeInput.value = 'single';
            nameInput.setAttribute('required', 'required');
            if (countInput) countInput.removeAttribute('required');
        }
    }

    if (addTypeSingle) addTypeSingle.addEventListener('change', toggle);
    if (addTypeBulk) addTypeBulk.addEventListener('change', toggle);
    toggle();
})();
</script>
@endsection
