@extends('layouts/contentNavbarLayout')

@section('title', 'Bed: ' . $bed->name)

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Bed: {{ $bed->name }}</h4>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.beds.edit', $bed) }}" class="btn btn-outline-primary">Edit</a>
            <form action="{{ route('admin.beds.destroy', $bed) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this bed?');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-outline-danger">Delete</button>
            </form>
            <a href="{{ route('admin.beds.index') }}" class="btn btn-outline-secondary">Back to list</a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <dl class="row mb-0">
                <dt class="col-sm-3">Bed name</dt>
                <dd class="col-sm-9">{{ $bed->name }}</dd>
                <dt class="col-sm-3">Room</dt>
                <dd class="col-sm-9"><a href="{{ route('admin.rooms.show', $bed->room) }}">{{ $bed->room->name }}</a></dd>
                <dt class="col-sm-3">Floor</dt>
                <dd class="col-sm-9"><a href="{{ route('admin.floors.show', $bed->room->floor) }}">{{ $bed->room->floor->name }}</a></dd>
                <dt class="col-sm-3">Rent Amount</dt>
                <dd class="col-sm-9">₹ {{ number_format($bed->rent_amount ?? 0, 2) }}</dd>
                <dt class="col-sm-3">Status</dt>
                <dd class="col-sm-9">
                    @if($bed->status === \App\Models\Bed::STATUS_AVAILABLE)
                        <span class="badge bg-success">Available</span>
                    @else
                        <span class="badge bg-secondary">Occupied</span>
                    @endif
                </dd>
            </dl>
        </div>
    </div>
</div>
@endsection
