@extends('layouts/contentNavbarLayout')

@section('title', 'Floor: ' . $floor->name)

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Floor: {{ $floor->name }}</h4>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.floors.edit', $floor) }}" class="btn btn-outline-primary">Edit</a>
            <form action="{{ route('admin.floors.destroy', $floor) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this floor? All rooms and beds on it will be removed.');">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-outline-danger">Delete</button>
            </form>
            <a href="{{ route('admin.floors.index') }}" class="btn btn-outline-secondary">Back to list</a>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <dl class="row mb-0">
                <dt class="col-sm-3">Name</dt>
                <dd class="col-sm-9">{{ $floor->name }}</dd>
                <dt class="col-sm-3">Capacity</dt>
                <dd class="col-sm-9">{{ $floor->capacity }}</dd>
                <dt class="col-sm-3">Sort order</dt>
                <dd class="col-sm-9">{{ $floor->sort_order }}</dd>
                <dt class="col-sm-3">Rooms</dt>
                <dd class="col-sm-9">{{ $floor->rooms_count }}</dd>
            </dl>
        </div>
    </div>

    @if($floor->rooms->isNotEmpty())
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Rooms on this floor</h5>
        </div>
        <div class="card-body">
            <ul class="list-group list-group-flush">
                @foreach($floor->rooms as $room)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <a href="{{ route('admin.rooms.show', $room) }}">{{ $room->name }}</a>
                        <span class="badge bg-primary rounded-pill">{{ $room->beds->count() }} bed(s)</span>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
    @endif
</div>
@endsection
