@extends('layouts/contentNavbarLayout')

@section('title', 'Account Settings')

@section('vendor-style')
<style>
.account-settings .nav-pills .nav-link { color: #697a8d; border-radius: 0.375rem; padding: 0.5rem 1rem; }
.account-settings .nav-pills .nav-link.active { color: #fff; background-color: #696cff; font-weight: 600; }
.account-settings .nav-pills .nav-link i { font-size: 1.125rem; }
.account-settings .profile-avatar { width: 100px; height: 100px; border-radius: 0.5rem; overflow: hidden; border: 2px solid var(--bs-border-color); }
.account-settings .profile-avatar img { width: 100%; height: 100%; object-fit: cover; }
.account-settings .password-toggle { cursor: pointer; }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y account-settings">
    <h4 class="fw-bold py-3 mb-4">Account Settings</h4>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <div class="col-md-12">
            <div class="nav-align-top">
                <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-2 gap-lg-0">
                    <li class="nav-item">
                        <a class="nav-link {{ $activeTab === 'account' ? 'active' : '' }}" href="{{ route('admin.profile.edit', ['tab' => 'account']) }}">
                            <i class="icon-base ri ri-group-line icon-sm me-1_5"></i>Account
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ $activeTab === 'security' ? 'active' : '' }}" href="{{ route('admin.profile.edit', ['tab' => 'security']) }}">
                            <i class="icon-base ri ri-lock-2-line icon-sm me-1_5"></i>Security
                        </a>
                    </li>
                </ul>
            </div>

            @if ($activeTab === 'account')
            {{-- Account tab --}}
            <div class="card mb-6">
                <div class="card-body">
                    <form action="{{ route('admin.profile.update') }}" method="POST" enctype="multipart/form-data" id="accountForm">
                        @csrf
                        @method('PATCH')
                        
                        {{-- Profile Photo --}}
                        <div class="d-flex align-items-start align-items-sm-center gap-6 pb-4 border-bottom">
                            <div class="profile-avatar d-block">
                                @if($user->avatar)
                                    <img id="profileAvatarImg" src="{{ asset('storage/' . $user->avatar) }}" alt="Avatar">
                                @else
                                    <img id="profileAvatarImg" src="{{ asset('assets/json/img/avatars/1.png') }}" alt="Avatar">
                                @endif
                            </div>
                            <div class="button-wrapper">
                                <label for="avatarInput" class="btn btn-sm btn-primary me-3 mb-4" tabindex="0">
                                    <span class="d-none d-sm-block">Upload new photo</span>
                                    <i class="icon-base ri ri-upload-2-line d-block d-sm-none"></i>
                                    <input type="file" id="avatarInput" name="avatar" class="d-none" accept="image/png,image/jpeg,image/gif" />
                                </label>
                                <button type="button" class="btn btn-sm btn-outline-danger mb-4" id="avatarResetBtn">
                                    <i class="icon-base ri ri-refresh-line d-block d-sm-none"></i>
                                    <span class="d-none d-sm-block">Reset</span>
                                </button>
                                <input type="hidden" name="avatar_remove" id="avatarRemove" value="0">
                                <div class="small">Allowed JPG, GIF or PNG. Max size of 800K</div>
                            </div>
                        </div>

                        {{-- Personal Information --}}
                        <div class="pt-4">
                            <h6 class="mb-4">Personal Information</h6>
                            <div class="row g-5">
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="fullName" name="name" value="{{ old('name', $user->name) }}" required placeholder="Full Name">
                                        <label for="fullName">Full Name <span class="text-danger">*</span></label>
                                        @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $user->email) }}" required placeholder="E-mail">
                                        <label for="email">E-mail <span class="text-danger">*</span></label>
                                        @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', $user->phone) }}" placeholder="Phone Number">
                                        <label for="phone">Phone Number</label>
                                        @error('phone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="date" class="form-control @error('date_of_birth') is-invalid @enderror" id="dateOfBirth" name="date_of_birth" value="{{ old('date_of_birth', $user->date_of_birth?->format('Y-m-d')) }}">
                                        <label for="dateOfBirth">Date of Birth</label>
                                        @error('date_of_birth')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Professional Information --}}
                        <div class="pt-4 mt-4 border-top">
                            <h6 class="mb-4">Professional Information</h6>
                            <div class="row g-5">
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control @error('organization') is-invalid @enderror" id="organization" name="organization" value="{{ old('organization', $user->organization) }}" placeholder="Organization">
                                        <label for="organization">Organization</label>
                                        @error('organization')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control @error('designation') is-invalid @enderror" id="designation" name="designation" value="{{ old('designation', $user->designation) }}" placeholder="Designation">
                                        <label for="designation">Designation</label>
                                        @error('designation')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control" id="role" value="{{ ucfirst($user->role ?? 'admin') }}" readonly>
                                        <label for="role">Role</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-6">
                            <button type="submit" class="btn btn-primary me-3">Save changes</button>
                            <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
            @endif

            @if ($activeTab === 'security')
            {{-- Security tab: Change Password --}}
            <div class="card mb-6">
                <div class="card-body">
                    <form action="{{ route('admin.profile.password.update') }}" method="POST" id="passwordForm">
                        @csrf
                        <h5 class="mb-4">Change Password</h5>
                        <div class="row g-5">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="password" class="form-control @error('current_password') is-invalid @enderror" id="currentPassword" name="current_password" required autocomplete="current-password" placeholder="Current Password">
                                    <label for="currentPassword">Current Password <span class="text-danger">*</span></label>
                                    @error('current_password')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                                <div class="form-text">
                                    <span class="password-toggle" data-target="currentPassword" style="display: inline-flex; align-items: center; cursor: pointer;">
                                        <i class="ri-eye-off-line me-2"></i>Show password
                                    </span>
                                </div>
                            </div>
                            <div class="col-12"></div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="password" class="form-control @error('password') is-invalid @enderror" id="newPassword" name="password" required autocomplete="new-password" minlength="8" placeholder="New Password">
                                    <label for="newPassword">New Password <span class="text-danger">*</span></label>
                                    @error('password')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                                <div class="form-text">
                                    <span class="password-toggle" data-target="newPassword" style="display: inline-flex; align-items: center; cursor: pointer;">
                                        <i class="ri-eye-off-line me-2"></i>Show password
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="password" class="form-control" id="confirmPassword" name="password_confirmation" required autocomplete="new-password" minlength="8" placeholder="Confirm Password">
                                    <label for="confirmPassword">Confirm New Password <span class="text-danger">*</span></label>
                                </div>
                                <div class="form-text">
                                    <span class="password-toggle" data-target="confirmPassword" style="display: inline-flex; align-items: center; cursor: pointer;">
                                        <i class="ri-eye-off-line me-2"></i>Show password
                                    </span>
                                </div>
                            </div>
                            <div class="col-12">
                                <h6 class="mb-2">Password Requirements:</h6>
                                <ul class="ps-4 mb-0">
                                    <li class="mb-1">Minimum 8 characters long - the more, the better</li>
                                    <li class="mb-1">At least one lowercase character</li>
                                    <li class="mb-0">At least one number, symbol, or whitespace character</li>
                                </ul>
                            </div>
                        </div>
                        <div class="mt-6">
                            <button type="submit" class="btn btn-primary me-3">Save changes</button>
                            <button type="reset" class="btn btn-outline-secondary">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script>
(function() {
    var avatarInput = document.getElementById('avatarInput');
    var profileImg = document.getElementById('profileAvatarImg');
    var avatarRemove = document.getElementById('avatarRemove');
    var avatarResetBtn = document.getElementById('avatarResetBtn');

    // Profile photo preview on upload
    if (avatarInput && profileImg) {
        avatarInput.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    profileImg.src = e.target.result;
                };
                reader.readAsDataURL(this.files[0]);
                if (avatarRemove) avatarRemove.value = '0';
            }
        });
    }

    // Reset avatar to default
    if (avatarResetBtn && avatarRemove && profileImg) {
        avatarResetBtn.addEventListener('click', function() {
            profileImg.src = @json(asset('assets/json/img/avatars/1.png'));
            avatarRemove.value = '1';
            if (avatarInput) avatarInput.value = '';
        });
    }

    // Password toggle (show/hide)
    document.querySelectorAll('.password-toggle').forEach(function(toggle) {
        toggle.addEventListener('click', function() {
            var targetId = this.getAttribute('data-target');
            var input = document.getElementById(targetId);
            var icon = this.querySelector('i');
            if (!input || !icon) return;
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('ri-eye-off-line');
                icon.classList.add('ri-eye-line');
                this.innerHTML = '<i class="ri-eye-line me-2"></i>Hide password';
            } else {
                input.type = 'password';
                icon.classList.remove('ri-eye-line');
                icon.classList.add('ri-eye-off-line');
                this.innerHTML = '<i class="ri-eye-off-line me-2"></i>Show password';
            }
        });
    });
})();
</script>
@endsection
