@extends('layouts/contentNavbarLayout')

@section('title', 'Rent Receipt Book')

@section('vendor-style')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" />
<style>
.receipt-user-cell { display: flex; align-items: center; gap: 0.75rem; }
.receipt-user-cell .avatar-wrap { flex-shrink: 0; width: 36px; height: 36px; border-radius: 50%; overflow: hidden; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 0.75rem; background: var(--bs-secondary-bg); }
.receipt-user-cell .avatar-wrap img { width: 100%; height: 100%; object-fit: cover; }
.receipt-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
@media print { .no-print { display: none !important; } .receipt-user-cell .avatar-wrap { display: none; } }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Rent Receipt Book</h4>
        <div class="d-flex gap-2 no-print">
            <button type="button" class="btn btn-outline-success btn-sm" id="exportExcel" title="Export Excel"><i class="ri-file-excel-2-line me-1"></i>Excel</button>
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="window.print();" title="Print"><i class="ri-printer-line me-1"></i>Print</button>
        </div>
    </div>

    <div class="card mb-4 no-print">
        <div class="card-body">
            <form method="get" action="{{ route('admin.receipts.rent') }}" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ $fromDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ $toDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Mode</label>
                    <select class="form-select" name="payment_mode">
                        <option value="">All</option>
                        @foreach($paymentModes as $key => $label)
                            <option value="{{ $key }}" {{ ($paymentMode ?? '') === $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Search</button>
                    <a href="{{ route('admin.receipts.rent') }}" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table receipt-table table-hover" id="rentReceiptTable">
                    <thead>
                        <tr>
                            <th>Receipt No.</th>
                            <th>Student</th>
                            <th>Rent Date</th>
                            <th>Period</th>
                            <th>Amount</th>
                            <th>Payment Mode</th>
                            <th class="no-print">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($rents as $r)
                            @php $s = $r->student; @endphp
                            <tr>
                                <td>{{ $r->receipt_no ?? 'R' . $r->id }}</td>
                                <td>
                                    <div class="receipt-user-cell">
                                        <div class="avatar-wrap">
                                            @if($s->documents->where('document_type', 'profile_photo')->first())
                                                <img src="{{ asset('storage/' . $s->documents->where('document_type', 'profile_photo')->first()->file_path) }}" alt="">
                                            @else
                                                {{ strtoupper(mb_substr($s->first_name ?? '', 0, 1)) }}
                                            @endif
                                        </div>
                                        <div><span class="fw-medium">{{ $s->full_name }}</span><span class="d-block small text-muted">{{ $s->student_mobile ?? '—' }}</span></div>
                                    </div>
                                </td>
                                <td>{{ $r->paid_at?->format('d/m/Y') ?? '—' }}</td>
                                <td>{{ $r->period_from->format('d/m/Y') }} – {{ $r->period_to->format('d/m/Y') }}</td>
                                <td>₹ {{ number_format($r->amount, 2) }}</td>
                                <td>{{ $paymentModes[$r->payment_mode] ?? $r->payment_mode }}</td>
                                <td class="no-print">
                                    <button type="button" class="btn btn-sm btn-outline-primary view-receipt-btn" data-url="{{ route('admin.rents.receipt', $r) }}" title="View Receipt"><i class="ri-eye-line"></i></button>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="7" class="text-center text-muted py-4">No rent records for the selected filter.</td></tr>
                        @endforelse
                    </tbody>
                    @if($rents->isNotEmpty())
                    <tfoot>
                        <tr class="table-light fw-bold">
                            <td colspan="4" class="text-end">Total</td>
                            <td>₹ {{ number_format($total, 2) }}</td>
                            <td></td>
                            <td class="no-print"></td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
            </div>
        </div>
    </div>

    {{-- Receipt Modal --}}
    <div class="modal fade" id="receiptModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="receiptModalTitle">Receipt</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="receiptModalBody">
                    <div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>
                </div>
                <div class="modal-footer flex-wrap gap-2">
                    <div class="d-flex align-items-center gap-2 flex-grow-1 flex-md-grow-0" id="receiptFileToShareWrap" style="display: none !important;">
                        <span class="text-muted small"><i class="ri-file-pdf-line text-danger me-1"></i>File to send:</span>
                        <span class="small fw-medium text-truncate" id="receiptFileToShareName" style="max-width: 180px;">—</span>
                    </div>
                    <div class="d-flex gap-2 flex-wrap">
                        <button type="button" class="btn btn-primary" id="printReceiptBtn"><i class="ri-printer-line me-1"></i>Print</button>
                        <button type="button" class="btn btn-success" id="whatsappShareBtn" style="display: none;" data-pdf-url="" data-receipt-no="" title="Send this file to WhatsApp">
                            <i class="ri-whatsapp-line me-1"></i>Send to WhatsApp
                        </button>
                        <div class="dropdown d-inline-block" id="shareReceiptWrap">
                            <button type="button" class="btn btn-outline-primary dropdown-toggle" id="shareReceiptBtn" data-bs-toggle="dropdown" aria-expanded="false" data-pdf-url="" data-email-type="" data-email-id="">
                                <i class="ri-share-line me-1"></i>More
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item receipt-download-pdf" href="#" rel="noopener"><i class="ri-file-download-line me-2"></i>Download PDF</a></li>
                                <li><a class="dropdown-item receipt-send-email" href="#" rel="noopener"><i class="ri-mail-send-line me-2 text-primary"></i>Send via Email</a></li>
                            </ul>
                        </div>
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                    <div class="w-100 small text-muted mt-2" id="whatsappFallbackMsg" style="display: none;">
                        This device cannot share the file directly. Download the PDF above, then open WhatsApp and attach it.
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        @media print {
            body * {
                visibility: hidden;
            }
            #receiptModal, #receiptModal * {
                visibility: visible;
            }
            #receiptModal {
                position: fixed;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                z-index: 9999;
            }
            #receiptModal .modal-dialog {
                position: absolute;
                left: 0;
                top: 0;
                margin: 0;
                padding: 0;
                max-width: 100%;
                width: 100%;
            }
            #receiptModal .modal-content {
                border: none;
                box-shadow: none;
            }
            #receiptModal .modal-header,
            #receiptModal .modal-footer {
                display: none !important;
            }
            #receiptModal .modal-body {
                padding: 20px !important;
            }
        }
    </style>
</div>
@endsection

@section('vendor-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
@endsection

@section('page-script')
<script>
(function() {
    // Initialize DataTable
    var table = $('#rentReceiptTable').DataTable({
        order: [[2, 'desc']], // Sort by Rent Date descending
        pageLength: 25,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ receipts",
            infoEmpty: "No receipts available",
            infoFiltered: "(filtered from _MAX_ total receipts)",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        },
        columnDefs: [
            { orderable: false, targets: -1 } // Disable sorting on Action column
        ]
    });

    var btn = document.getElementById('exportExcel');
    if (btn) btn.addEventListener('click', function() {
        var tableEl = document.getElementById('rentReceiptTable');
        if (!tableEl) return;
        var wb = XLSX.utils.table_to_book(tableEl, { sheet: 'Rent Receipt Book', raw: true });
        XLSX.writeFile(wb, 'rent-receipt-book-' + new Date().toISOString().slice(0,10) + '.xlsx');
    });

    // Receipt modal
    var receiptModalEl = document.getElementById('receiptModal');
    var modalTitle = document.getElementById('receiptModalTitle');
    var modalBody = document.getElementById('receiptModalBody');
    var printBtn = document.getElementById('printReceiptBtn');
    
    if (!receiptModalEl) return;
    
    // Print receipt button
    if (printBtn) {
        printBtn.addEventListener('click', function() {
            window.print();
        });
    }

    // Send to WhatsApp: one tap – fetch PDF and share via Web Share API (file is sent)
    var whatsappBtn = document.getElementById('whatsappShareBtn');
    var fileToShareWrap = document.getElementById('receiptFileToShareWrap');
    var fileToShareName = document.getElementById('receiptFileToShareName');
    var whatsappFallbackMsg = document.getElementById('whatsappFallbackMsg');

    if (whatsappBtn) {
        whatsappBtn.addEventListener('click', function() {
            var pdfUrl = this.dataset.pdfUrl;
            var fileName = 'rent-receipt-' + (this.dataset.receiptNo || '') + '.pdf';
            if (!pdfUrl) return;
            whatsappBtn.disabled = true;
            whatsappBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-1"></span>Sending…';
            fetch(pdfUrl, { credentials: 'same-origin' })
                .then(function(res) { return res.blob(); })
                .then(function(blob) {
                    var file = new File([blob], fileName, { type: 'application/pdf' });
                    if (typeof navigator.share === 'function') {
                        var shareData = { files: [file], title: 'Rent Receipt' };
                        try {
                            if (navigator.canShare && !navigator.canShare(shareData)) throw new Error('cannot share files');
                            return navigator.share(shareData);
                        } catch (err) {
                            throw err;
                        }
                    } else {
                        throw new Error('Share not supported');
                    }
                })
                .then(function() {
                    whatsappBtn.disabled = false;
                    whatsappBtn.innerHTML = '<i class="ri-whatsapp-line me-1"></i>Send to WhatsApp';
                })
                .catch(function() {
                    whatsappBtn.disabled = false;
                    whatsappBtn.innerHTML = '<i class="ri-whatsapp-line me-1"></i>Send to WhatsApp';
                    if (whatsappFallbackMsg) whatsappFallbackMsg.style.display = 'block';
                });
        });
    }

    receiptModalEl.addEventListener('click', function(e) {
        var shareBtn = document.getElementById('shareReceiptBtn');
        var t = e.target.closest('a');
        if (!shareBtn) return;

        if (t && t.classList.contains('receipt-download-pdf') && shareBtn.dataset.pdfUrl) {
            e.preventDefault();
            window.location.href = shareBtn.dataset.pdfUrl;
        } else if (t && t.classList.contains('receipt-send-email') && shareBtn.dataset.emailType) {
            e.preventDefault();
            var email = prompt('Enter email address to send the receipt (PDF file):');
            if (!email || !email.trim()) return;
            var csrf = document.querySelector('meta[name="csrf-token"]');
            fetch('{{ route("admin.share.send-email") }}', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json', 'Accept': 'application/json', 'X-CSRF-TOKEN': csrf ? csrf.content : '' },
                body: JSON.stringify({ type: shareBtn.dataset.emailType, id: parseInt(shareBtn.dataset.emailId, 10), email: email.trim() })
            }).then(function(r) { return r.json(); }).then(function(d) {
                if (d.success) alert('Document sent to ' + email.trim());
                else alert(d.message || 'Failed to send');
            }).catch(function() { alert('Failed to send'); });
        }
    });
    
    document.querySelectorAll('.view-receipt-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            var url = this.getAttribute('data-url');
            modalBody.innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div></div>';
            
            // Show modal using Bootstrap's data-bs-toggle or create instance
            var modalInstance = window.bootstrap ? new bootstrap.Modal(receiptModalEl) : new Modal(receiptModalEl);
            modalInstance.show();
            
            fetch(url, {
                headers: {
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    modalTitle.textContent = data.title;
                    modalBody.innerHTML = data.html;
                    var shareBtn = document.getElementById('shareReceiptBtn');
                    var wabtn = document.getElementById('whatsappShareBtn');
                    var receiptFileName = 'rent-receipt-' + (data.receiptNo || ('R' + (data.rentId || ''))) + '.pdf';
                    if (shareBtn && data.pdfDownloadUrl) {
                        shareBtn.dataset.pdfUrl = data.pdfDownloadUrl;
                        shareBtn.dataset.receiptNo = data.receiptNo || ('R' + (data.rentId || ''));
                        shareBtn.dataset.emailType = data.emailType || 'rent';
                        shareBtn.dataset.emailId = data.emailId || '';
                    }
                    if (wabtn) {
                        wabtn.dataset.pdfUrl = data.pdfDownloadUrl || '';
                        wabtn.dataset.receiptNo = data.receiptNo || ('R' + (data.rentId || ''));
                        wabtn.style.display = data.pdfDownloadUrl ? '' : 'none';
                    }
                    if (fileToShareWrap && fileToShareName) {
                        fileToShareWrap.style.display = data.pdfDownloadUrl ? 'flex' : 'none';
                        fileToShareName.textContent = receiptFileName;
                    }
                    if (whatsappFallbackMsg) whatsappFallbackMsg.style.display = 'none';
                } else {
                    modalBody.innerHTML = '<div class="alert alert-danger">Failed to load receipt</div>';
                }
            })
            .catch(error => {
                modalBody.innerHTML = '<div class="alert alert-danger">Error loading receipt</div>';
            });
        });
    });
})();
</script>
@endsection
