@extends('layouts/contentNavbarLayout')

@section('title', 'Add Rent')

@section('vendor-style')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Add Rent</h4>
        <a href="{{ route('admin.rents.index') }}" class="btn btn-outline-secondary"><i class="ri-arrow-left-line me-1"></i>Back to Rent Management</a>
    </div>

    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.rents.index') }}">Rent Management</a></li>
            <li class="breadcrumb-item active">Add Rent</li>
        </ol>
    </nav>

    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">Rent Entry (multi-month)</h5>
            <button type="button" class="btn btn-sm btn-outline-primary" id="addEntryRow"><i class="ri-add-line me-1"></i>Add Row</button>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.rents.store') }}" method="POST" id="addRentForm">
                @csrf

                <div class="row g-3 mb-4">
                    @if($selectedStudent)
                        <div class="col-md-6">
                            <label class="form-label">Student <span class="text-danger">*</span></label>
                            <input type="text" class="form-control bg-light" value="{{ $selectedStudent->id }} — {{ $selectedStudent->full_name }}" readonly>
                            <input type="hidden" name="student_id" value="{{ $selectedStudent->id }}" id="student_id">
                            @if($selectedStudent->bed)
                                <p class="form-text mb-0 mt-1">Rent (bed): ₹{{ number_format($selectedStudent->bed->rent_amount ?? 0, 2) }}
                                    @if($minRewardForRedeem && ($selectedStudent->reward_points ?? 0) >= $minRewardForRedeem)
                                        · Reward points: {{ $selectedStudent->reward_points }} (can redeem)
                                    @endif
                                </p>
                            @endif
                        </div>
                    @else
                        <div class="col-md-6">
                            <label class="form-label">Student <span class="text-danger">*</span></label>
                            <select class="form-select select2-student @error('student_id') is-invalid @enderror" name="student_id" id="student_id" required data-placeholder="— Select Student —">
                                <option value="">— Select Student —</option>
                                @foreach($students as $s)
                                    <option value="{{ $s->id }}"
                                        data-rent="{{ $s->bed ? ($s->bed->rent_amount ?? 0) : 0 }}"
                                        data-points="{{ $s->reward_points ?? 0 }}"
                                        {{ old('student_id') == $s->id ? 'selected' : '' }}>
                                        {{ $s->id }} — {{ $s->full_name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('student_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <p class="form-text mb-0 mt-1" id="studentRentInfo">Select a student to see bed rent.</p>
                        </div>
                    @endif
                </div>

                <div id="entriesContainer">
                    @php
                        $oldEntries = old('entries', [['period_from' => '', 'period_to' => '', 'due_date' => '', 'amount' => '', 'reward_discount' => '0']]);
                        if (empty($oldEntries)) {
                            $oldEntries = [['period_from' => '', 'period_to' => '', 'due_date' => '', 'amount' => '', 'reward_discount' => '0']];
                        }
                    @endphp
                    @foreach($oldEntries as $idx => $entry)
                    <div class="entry-row border rounded p-3 mb-3 bg-light bg-opacity-50" data-index="{{ $idx }}">
                        <div class="row g-2 align-items-end">
                            <div class="col-md-2">
                                <label class="form-label small">From <span class="text-danger">*</span></label>
                                <input type="date" class="form-control form-control-sm" name="entries[{{ $idx }}][period_from]" value="{{ $entry['period_from'] ?? '' }}" required>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small">To <span class="text-danger">*</span></label>
                                <input type="date" class="form-control form-control-sm" name="entries[{{ $idx }}][period_to]" value="{{ $entry['period_to'] ?? '' }}" required>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small">Due Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control form-control-sm" name="entries[{{ $idx }}][due_date]" value="{{ $entry['due_date'] ?? '' }}" required>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label small">Amount <span class="text-danger">*</span></label>
                                <input type="number" class="form-control form-control-sm entry-amount" name="entries[{{ $idx }}][amount]" value="{{ $entry['amount'] ?? '' }}" min="0" step="0.01" required>
                            </div>
                            @if($minRewardForRedeem)
                            <div class="col-md-2">
                                <label class="form-label small">Reward Discount</label>
                                <input type="number" class="form-control form-control-sm" name="entries[{{ $idx }}][reward_discount]" value="{{ $entry['reward_discount'] ?? '0' }}" min="0" step="0.01" placeholder="0">
                            </div>
                            @else
                                <input type="hidden" name="entries[{{ $idx }}][reward_discount]" value="0">
                            @endif
                            <div class="col-md-1">
                                <button type="button" class="btn btn-sm btn-outline-danger remove-entry" title="Remove row"><i class="ri-subtract-line"></i></button>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>

                <hr class="my-4">
                <h6 class="mb-3">Payment Details</h6>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Payment Mode <span class="text-danger">*</span></label>
                        <select class="form-select @error('payment_mode') is-invalid @enderror" name="payment_mode" required>
                            <option value="">— Select —</option>
                            @foreach($paymentModes as $key => $label)
                                <option value="{{ $key }}" {{ old('payment_mode') === $key ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                        @error('payment_mode')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">UTR / Transaction ID</label>
                        <input type="text" class="form-control" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="For UPI/NEFT/Card">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Cheque Number</label>
                        <input type="text" class="form-control" name="cheque_number" value="{{ old('cheque_number') }}" placeholder="For cheque payment">
                    </div>
                </div>

                <hr class="my-4">
                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary"><i class="ri-check-line me-1"></i>Submit</button>
                    <a href="{{ route('admin.rents.index') }}" class="btn btn-outline-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
(function() {
    var minRewardForRedeem = {{ (int) ($minRewardForRedeem ?? 0) }};
    var $ = window.jQuery;
    if (!$) return;

    var container = document.getElementById('entriesContainer');
    var studentSelect = document.getElementById('student_id');
    var studentRentInfo = document.getElementById('studentRentInfo');

    function getNextIndex() {
        var rows = container.querySelectorAll('.entry-row');
        var max = -1;
        rows.forEach(function(r) {
            var i = parseInt(r.getAttribute('data-index'), 10);
            if (!isNaN(i) && i > max) max = i;
        });
        return max + 1;
    }

    function cloneRow() {
        var idx = getNextIndex();
        var firstRow = container.querySelector('.entry-row');
        if (!firstRow) return;
        var html = firstRow.outerHTML
            .replace(/entries\[\d+\]/g, 'entries[' + idx + ']')
            .replace(/data-index="\d+"/, 'data-index="' + idx + '"');
        var div = document.createElement('div');
        div.innerHTML = html;
        var newRow = div.firstElementChild;
        container.appendChild(newRow);
        newRow.querySelectorAll('input[type="date"], input.entry-amount, input[name*="reward_discount"]').forEach(function(inp) {
            inp.value = inp.name.indexOf('reward_discount') !== -1 ? '0' : '';
        });
        bindRemove();
    }

    function bindRemove() {
        container.querySelectorAll('.remove-entry').forEach(function(btn) {
            if (btn._bound) return;
            btn._bound = true;
            btn.addEventListener('click', function() {
                var row = btn.closest('.entry-row');
                if (container.querySelectorAll('.entry-row').length > 1) row.remove();
            });
        });
    }

    document.getElementById('addEntryRow').addEventListener('click', cloneRow);
    bindRemove();

    if (studentSelect && studentSelect.tagName === 'SELECT' && studentRentInfo) {
        $(studentSelect).select2({ theme: 'bootstrap-5', placeholder: '— Select Student —', allowClear: true, width: '100%' });
        $(studentSelect).on('change', function() {
            var opt = studentSelect.options[studentSelect.selectedIndex];
            if (opt && opt.value) {
                var rent = parseFloat(opt.getAttribute('data-rent')) || 0;
                var points = parseInt(opt.getAttribute('data-points'), 10) || 0;
                studentRentInfo.textContent = 'Rent (bed): ₹' + rent.toFixed(2);
                if (minRewardForRedeem && points >= minRewardForRedeem) {
                    studentRentInfo.textContent += ' · Reward points: ' + points + ' (can redeem)';
                }
            } else {
                studentRentInfo.textContent = 'Select a student to see bed rent.';
            }
        });
        $(studentSelect).trigger('change');
    }
})();
</script>
@endsection
