@extends('layouts/contentNavbarLayout')

@section('title', 'Period Report')

@section('vendor-style')
<style>
.report-table thead th { font-weight: 600; text-transform: uppercase; font-size: 0.75rem; }
@media print { .no-print { display: none !important; } }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Period Report</h4>
        <div class="d-flex gap-2 no-print">
            <a href="{{ route('admin.reports.index') }}" class="btn btn-outline-secondary btn-sm"><i class="ri-arrow-left-line me-1"></i>Back to Reports</a>
            <button type="button" class="btn btn-outline-success btn-sm" id="exportExcel" title="Export Excel"><i class="ri-file-excel-2-line me-1"></i>Excel</button>
            <button type="button" class="btn btn-outline-secondary btn-sm" onclick="window.print();" title="Print"><i class="ri-printer-line me-1"></i>Print</button>
        </div>
    </div>

    {{-- Filters --}}
    <div class="card mb-4 no-print">
        <div class="card-body">
            <form method="get" action="{{ route('admin.reports.period') }}" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="{{ $fromDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="{{ $toDate ?? '' }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Type</label>
                    <select class="form-select" name="payment_type">
                        <option value="all" {{ ($paymentType ?? '') === 'all' ? 'selected' : '' }}>All</option>
                        <option value="rent" {{ ($paymentType ?? '') === 'rent' ? 'selected' : '' }}>Rent</option>
                        <option value="deposit" {{ ($paymentType ?? '') === 'deposit' ? 'selected' : '' }}>Deposit</option>
                        <option value="expense" {{ ($paymentType ?? '') === 'expense' ? 'selected' : '' }}>Expense</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Payment Mode</label>
                    <select class="form-select" name="payment_mode">
                        <option value="">All</option>
                        @foreach($paymentModes as $key => $label)
                            <option value="{{ $key }}" {{ ($paymentMode ?? '') === $key ? 'selected' : '' }}>{{ $label }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Search</button>
                    <a href="{{ route('admin.reports.period') }}" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    {{-- Table --}}
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table report-table table-hover" id="periodReportTable">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Type</th>
                            <th>Description</th>
                            <th class="text-end">Amount (₹)</th>
                            <th>Payment Mode</th>
                            <th>Reference</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($rows as $row)
                            <tr>
                                <td>{{ $row->date_display }}</td>
                                <td>
                                    @if($row->type === 'Rent')
                                        <span class="badge bg-label-primary">Rent</span>
                                    @elseif($row->type === 'Deposit')
                                        <span class="badge bg-label-info">Deposit</span>
                                    @else
                                        <span class="badge bg-label-danger">Expense</span>
                                    @endif
                                </td>
                                <td>{{ $row->description }}</td>
                                <td class="text-end {{ $row->amount < 0 ? 'text-danger' : '' }}">₹ {{ number_format($row->amount, 2) }}</td>
                                <td>{{ $paymentModes[$row->payment_mode] ?? $row->payment_mode ?? '—' }}</td>
                                <td>{{ $row->reference ?? '—' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="6" class="text-center text-muted py-4">No transactions for the selected filters.</td></tr>
                        @endforelse
                    </tbody>
                    @if($rows->isNotEmpty())
                    <tfoot>
                        <tr class="table-light fw-bold">
                            <td colspan="3" class="text-end">Total</td>
                            <td class="text-end {{ $total < 0 ? 'text-danger' : '' }}">₹ {{ number_format($total, 2) }}</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
(function() {
    var btn = document.getElementById('exportExcel');
    if (btn) btn.addEventListener('click', function() {
        var table = document.getElementById('periodReportTable');
        if (!table) return;
        var wb = XLSX.utils.table_to_book(table, { sheet: 'Period Report', raw: true });
        XLSX.writeFile(wb, 'period-report-' + new Date().toISOString().slice(0,10) + '.xlsx');
    });
})();
</script>
@endsection
