@extends('layouts/contentNavbarLayout')

@section('title', 'Student Registration – Step 1')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4">Student Registration – Step 1: Personal & Academic Details</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.students.registration.storeStep1') }}" method="POST">
                @csrf
                <h6 class="mb-3">Personal Information</h6>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">First Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="first_name" value="{{ old('first_name') }}" required />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Middle Name</label>
                        <input type="text" class="form-control" name="middle_name" value="{{ old('middle_name') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Last Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="last_name" value="{{ old('last_name') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" name="email" value="{{ old('email') }}" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Date of Birth</label>
                        <input type="date" class="form-control" name="date_of_birth" value="{{ old('date_of_birth') }}" />
                    </div>
                    <div class="col-12">
                        <label class="form-label">Permanent Address – Locality</label>
                        <input type="text" class="form-control" name="permanent_locality" value="{{ old('permanent_locality') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Taluka / Village</label>
                        <input type="text" class="form-control" name="permanent_taluka" value="{{ old('permanent_taluka') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">District</label>
                        <input type="text" class="form-control" name="permanent_district" value="{{ old('permanent_district') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">State</label>
                        <input type="text" class="form-control" name="permanent_state" value="{{ old('permanent_state') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Student Mobile</label>
                        <input type="text" class="form-control" name="student_mobile" value="{{ old('student_mobile') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Parent Mobile</label>
                        <input type="text" class="form-control" name="parent_mobile" value="{{ old('parent_mobile') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Student Aadhar Number</label>
                        <input type="text" class="form-control" name="aadhar_number" value="{{ old('aadhar_number') }}" />
                    </div>
                </div>

                <hr class="my-4" />
                <h6 class="mb-3">Academic Information</h6>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Standard / Year</label>
                        <input type="text" class="form-control" name="standard_year" value="{{ old('standard_year') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Stream</label>
                        <select class="form-select" name="stream">
                            <option value="">Select</option>
                            @foreach($streams as $key => $label)
                                <option value="{{ $key }}" {{ old('stream') == $key ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">College / Class Name</label>
                        <input type="text" class="form-control" name="college_name" value="{{ old('college_name') }}" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">College In Time</label>
                        <input type="time" class="form-control" name="college_in_time" value="{{ old('college_in_time') }}" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">College Out Time</label>
                        <input type="time" class="form-control" name="college_out_time" value="{{ old('college_out_time') }}" />
                    </div>
                </div>

                <hr class="my-4" />
                <h6 class="mb-3">Local Reference</h6>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Reference Name</label>
                        <input type="text" class="form-control" name="reference_name" value="{{ old('reference_name') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Relation to Student</label>
                        <input type="text" class="form-control" name="reference_relation" value="{{ old('reference_relation') }}" />
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Reference Contact</label>
                        <input type="text" class="form-control" name="reference_contact" value="{{ old('reference_contact') }}" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Referred By (Active Student)</label>
                        <select class="form-select" name="reference_by_student_id">
                            <option value="">None</option>
                            @foreach($students as $s)
                                <option value="{{ $s->id }}" {{ old('reference_by_student_id') == $s->id ? 'selected' : '' }}>{{ $s->full_name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <hr class="my-4" />
                <div class="form-check mb-4">
                    <input type="checkbox" class="form-check-input" name="terms_accepted" id="terms_accepted" value="1" {{ old('terms_accepted') ? 'checked' : '' }} required />
                    <label class="form-check-label" for="terms_accepted">I agree to the Terms & Conditions <span class="text-danger">*</span></label>
                </div>

                <button type="submit" class="btn btn-primary">Save & Continue to Step 2</button>
                <a href="{{ route('admin.students.index') }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection
