@extends('layouts/contentNavbarLayout')

@section('title', 'Student Registration – Step 3')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('admin.students.registration._steps_nav', ['currentStep' => 3, 'student' => $student])

    <h4 class="fw-bold py-3 mb-4">Step 3: Bed Allotment</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <p class="text-muted small mb-4">Select floor, then room (only rooms with vacant beds), then an available bed.</p>
            <form action="{{ route('admin.students.registration.storeStep3', $student) }}" method="POST" id="step3-form">
                @csrf
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Floor <span class="text-danger">*</span></label>
                        <select name="floor_id" id="floor_id" class="form-select" required>
                            <option value="">— Select Floor —</option>
                            @foreach($floors as $f)
                                <option value="{{ $f->id }}" {{ old('floor_id') == $f->id ? 'selected' : '' }}>{{ $f->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Room <span class="text-danger">*</span></label>
                        <select name="room_id" id="room_id" class="form-select" required disabled>
                            <option value="">— Select Room —</option>
                        </select>
                        <span class="small text-muted" id="room-loading" style="display: none;">Loading…</span>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Bed <span class="text-danger">*</span></label>
                        <select name="bed_id" id="bed_id" class="form-select" required disabled>
                            <option value="">— Select Bed —</option>
                        </select>
                        <span class="small text-muted" id="bed-loading" style="display: none;">Loading…</span>
                    </div>
                </div>
                <hr class="my-4" />
                <button type="submit" class="btn btn-primary">Allot Bed & Continue to Step 4</button>
                <a href="{{ route('admin.students.index') }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>

@section('page-script')
<script>
(function () {
    const floorSelect = document.getElementById('floor_id');
    const roomSelect = document.getElementById('room_id');
    const bedSelect = document.getElementById('bed_id');
    const roomLoading = document.getElementById('room-loading');
    const bedLoading = document.getElementById('bed-loading');
    const baseUrl = '{{ url("/admin/students/api") }}';

    function clearRooms() {
        roomSelect.innerHTML = '<option value="">— Select Room —</option>';
        roomSelect.disabled = true;
        clearBeds();
    }
    function clearBeds() {
        bedSelect.innerHTML = '<option value="">— Select Bed —</option>';
        bedSelect.disabled = true;
    }

    floorSelect.addEventListener('change', function () {
        const floorId = this.value;
        clearRooms();
        if (!floorId) return;
        roomLoading.style.display = 'inline';
        fetch(baseUrl + '/floors/' + floorId + '/rooms')
            .then(r => r.json())
            .then(rooms => {
                roomLoading.style.display = 'none';
                rooms.forEach(function (r) {
                    const opt = document.createElement('option');
                    opt.value = r.id;
                    opt.textContent = r.name;
                    roomSelect.appendChild(opt);
                });
                roomSelect.disabled = false;
                var oldRoom = '{{ old("room_id") }}';
                if (oldRoom) roomSelect.value = oldRoom;
                if (roomSelect.value) roomSelect.dispatchEvent(new Event('change'));
            })
            .catch(() => {
                roomLoading.style.display = 'none';
                roomSelect.disabled = false;
            });
    });

    roomSelect.addEventListener('change', function () {
        const roomId = this.value;
        clearBeds();
        if (!roomId) return;
        bedLoading.style.display = 'inline';
        fetch(baseUrl + '/rooms/' + roomId + '/beds')
            .then(r => r.json())
            .then(beds => {
                bedLoading.style.display = 'none';
                beds.forEach(function (b) {
                    const opt = document.createElement('option');
                    opt.value = b.id;
                    opt.textContent = b.name;
                    bedSelect.appendChild(opt);
                });
                bedSelect.disabled = false;
                var oldBed = '{{ old("bed_id") }}';
                if (oldBed) bedSelect.value = oldBed;
            })
            .catch(() => {
                bedLoading.style.display = 'none';
                bedSelect.disabled = false;
            });
    });

    var oldFloor = '{{ old("floor_id") }}';
    if (oldFloor && floorSelect.querySelector('option[value="' + oldFloor + '"]')) {
        floorSelect.value = oldFloor;
        floorSelect.dispatchEvent(new Event('change'));
    }
})();
</script>
@endsection
