@extends('layouts/contentNavbarLayout')

@section('title', 'Student Registration – Step 5')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    @include('admin.students.registration._steps_nav', ['currentStep' => 5, 'student' => $student])

    <h4 class="fw-bold py-3 mb-4">Step 5: Final Payment & Activation</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <p class="text-muted small mb-4">Record the first rent payment. On submit, the student will be marked active and a welcome SMS will be sent if configured.</p>
            <form action="{{ route('admin.students.registration.storeStep5', $student) }}" method="POST">
                @csrf
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Rent Period – From Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="period_from" value="{{ old('period_from') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Rent Period – To Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="period_to" value="{{ old('period_to') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Rent Due Date (next month) <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" name="due_date" value="{{ old('due_date') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Amount (₹) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="amount" step="0.01" min="0" value="{{ old('amount') }}" required />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Payment Mode <span class="text-danger">*</span></label>
                        <select name="payment_mode" class="form-select" required>
                            <option value="">— Select —</option>
                            @foreach($paymentModes as $key => $label)
                                <option value="{{ $key }}" {{ old('payment_mode') === $key ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Transaction ID / UTR Number</label>
                        <input type="text" class="form-control" name="transaction_id" value="{{ old('transaction_id') }}" placeholder="Optional" />
                    </div>
                </div>
                <hr class="my-4" />
                <button type="submit" class="btn btn-primary">Complete Registration & Activate Student</button>
                <a href="{{ route('admin.students.index') }}" class="btn btn-outline-secondary">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection
