@extends('layouts/contentNavbarLayout')

@section('title', 'Switch Student')

@section('vendor-style')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
<style>
.switch-row { display: flex; align-items: flex-end; gap: 0.75rem; flex-wrap: wrap; }
.switch-row .form-group { flex: 1; min-width: 180px; }
.switch-row .exchange-icon { flex-shrink: 0; width: 40px; height: 40px; display: inline-flex; align-items: center; justify-content: center; background: var(--bs-primary-bg-subtle); color: var(--bs-primary); border-radius: 0.375rem; }
</style>
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Switch Student</h4>
        <a href="{{ route('admin.students.index') }}" class="btn btn-outline-secondary"><i class="ri-arrow-left-line me-1"></i>Student Details</a>
    </div>

    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.students.index') }}">Students</a></li>
            <li class="breadcrumb-item active">Switch Student</li>
        </ol>
    </nav>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">Room reallocation</h5>
            <button type="button" class="btn btn-sm btn-outline-primary" id="addSwitchRow"><i class="ri-add-line me-1"></i>Add Row</button>
        </div>
        <div class="card-body">
            <p class="text-muted small mb-4">Move students to a new room/bed. Ensure the target bed is vacant. Effectivity date is when the change takes effect. Room history is updated for audit.</p>

            <form action="{{ route('admin.students.switch.store') }}" method="POST" id="switchForm">
                @csrf

                <div class="row g-3 mb-4">
                    <div class="col-md-4">
                        <label class="form-label">Effectivity Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control @error('effectivity_date') is-invalid @enderror" name="effectivity_date" value="{{ old('effectivity_date', date('Y-m-d')) }}" required>
                        @error('effectivity_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <p class="form-text mb-0">Date the room change takes place.</p>
                    </div>
                </div>

                <div id="switchRowsContainer">
                    @php
                        $oldSwitches = old('switches', [['student_id' => '', 'target_bed_id' => '']]);
                        if (empty($oldSwitches)) {
                            $oldSwitches = [['student_id' => '', 'target_bed_id' => '']];
                        }
                    @endphp
                    @foreach($oldSwitches as $idx => $row)
                    <div class="switch-row border rounded p-3 mb-3 bg-light bg-opacity-50" data-index="{{ $idx }}">
                        <div class="form-group">
                            <label class="form-label small">Student ID <span class="text-danger">*</span></label>
                            <select class="form-select form-select-sm switch-student" name="switches[{{ $idx }}][student_id]" data-placeholder="— Select Student —">
                                <option value="">— Select Student —</option>
                                @foreach($students as $s)
                                    <option value="{{ $s->id }}" {{ ($row['student_id'] ?? '') == $s->id ? 'selected' : '' }}>
                                        {{ $s->id }} — {{ $s->full_name }} ({{ $s->room_bed_identifier ?? '—' }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="exchange-icon"><i class="fas fa-exchange-alt"></i></div>
                        <div class="form-group">
                            <label class="form-label small">Target Room / Bed <span class="text-danger">*</span></label>
                            <select class="form-select form-select-sm switch-bed" name="switches[{{ $idx }}][target_bed_id]" data-placeholder="— Select Bed —">
                                <option value="">— Select Bed —</option>
                                @foreach($availableBeds as $b)
                                    <option value="{{ $b['id'] }}" {{ ($row['target_bed_id'] ?? '') == $b['id'] ? 'selected' : '' }}>{{ $b['label'] }}</option>
                                @endforeach
                            </select>
                            <p class="form-text small mb-0">Vacant beds only.</p>
                        </div>
                        <div>
                            <button type="button" class="btn btn-sm btn-outline-danger remove-row" title="Remove row"><i class="ri-subtract-line"></i></button>
                        </div>
                    </div>
                    @endforeach
                </div>

                <hr class="my-4">
                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary"><i class="ri-check-line me-1"></i>Submit Switch</button>
                    <a href="{{ route('admin.students.switch') }}" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
(function() {
    var $ = window.jQuery;
    if (!$) return;

    var container = document.getElementById('switchRowsContainer');

    function getNextIndex() {
        var rows = container.querySelectorAll('.switch-row');
        var max = -1;
        rows.forEach(function(r) {
            var i = parseInt(r.getAttribute('data-index'), 10);
            if (!isNaN(i) && i > max) max = i;
        });
        return max + 1;
    }

    function addRow() {
        var idx = getNextIndex();
        var firstRow = container.querySelector('.switch-row');
        if (!firstRow) return;
        var clone = firstRow.cloneNode(true);
        clone.setAttribute('data-index', idx);
        clone.querySelectorAll('select').forEach(function(sel) {
            sel.name = sel.name.replace(/switches\[\d+\]/, 'switches[' + idx + ']');
            sel.selectedIndex = 0;
        });
        clone.querySelectorAll('.select2-container').forEach(function(el) { el.remove(); });
        container.appendChild(clone);
        $(clone).find('.switch-student').select2({ theme: 'bootstrap-5', placeholder: '— Select Student —', allowClear: true, width: '100%' });
        $(clone).find('.switch-bed').select2({ theme: 'bootstrap-5', placeholder: '— Select Bed —', allowClear: true, width: '100%' });
        bindRemove();
    }

    function bindRemove() {
        container.querySelectorAll('.remove-row').forEach(function(btn) {
            if (btn._bound) return;
            btn._bound = true;
            btn.addEventListener('click', function() {
                var row = btn.closest('.switch-row');
                if (container.querySelectorAll('.switch-row').length > 1) row.remove();
            });
        });
    }

    document.getElementById('addSwitchRow').addEventListener('click', addRow);
    bindRemove();

    container.querySelectorAll('.switch-student, .switch-bed').forEach(function(sel) {
        $(sel).select2({ theme: 'bootstrap-5', placeholder: $(sel).data('placeholder') || '— Select —', allowClear: true, width: '100%' });
    });
})();
</script>
@endsection
