@extends('layouts/contentNavbarLayout')

@section('title', 'About Section - Website')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0">About Section Settings</h4>
        <a href="{{ route('home') }}#about" class="btn btn-outline-primary" target="_blank">
            <i class="ri-eye-line me-1"></i>Preview Site
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.website.about.update') }}" method="POST">
                @csrf
                
                <div class="row g-4">
                    <!-- About Title -->
                    <div class="col-12">
                        <label class="form-label">Section Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('about_title') is-invalid @enderror" name="about_title" value="{{ old('about_title', $settings->about_title) }}" required placeholder="About Our Hostel">
                        @error('about_title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <!-- About Description -->
                    <div class="col-12">
                        <label class="form-label">Description <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('about_description') is-invalid @enderror" name="about_description" rows="8" required placeholder="Write about your hostel...">{{ old('about_description', $settings->about_description) }}</textarea>
                        @error('about_description')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Write compelling content about your hostel. You can use line breaks for paragraphs.</div>
                    </div>

                    <!-- Statistics -->
                    <div class="col-12">
                        <h6 class="mb-3">Statistics</h6>
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Number of Residents <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('stat_residents') is-invalid @enderror" name="stat_residents" value="{{ old('stat_residents', $settings->stat_residents) }}" min="0" required>
                        @error('stat_residents')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Displayed as "100+ Happy Residents"</div>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Years of Experience <span class="text-danger">*</span></label>
                        <input type="number" class="form-control @error('stat_experience') is-invalid @enderror" name="stat_experience" value="{{ old('stat_experience', $settings->stat_experience) }}" min="0" required>
                        @error('stat_experience')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Displayed as "5+ Years Experience"</div>
                    </div>

                    <!-- Submit -->
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-save-line me-1"></i>Save Changes
                        </button>
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Preview Card -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="card-title mb-0">Current Preview</h5>
        </div>
        <div class="card-body">
            <h4 class="mb-3">{{ $settings->about_title ?? 'About Our Hostel' }}</h4>
            <p class="text-muted mb-4">{!! nl2br(e($settings->about_description)) !!}</p>
            <div class="row g-3">
                <div class="col-6">
                    <div class="border rounded p-3 text-center">
                        <div class="h2 text-primary mb-1">{{ $settings->stat_residents }}+</div>
                        <div class="text-muted small">Happy Residents</div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="border rounded p-3 text-center">
                        <div class="h2 text-primary mb-1">{{ $settings->stat_experience }}+</div>
                        <div class="text-muted small">Years Experience</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
