@extends('layouts/contentNavbarLayout')

@section('title', 'General Settings - Website')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0">General Website Settings</h4>
        <a href="{{ route('home') }}" class="btn btn-outline-primary" target="_blank">
            <i class="ri-eye-line me-1"></i>Preview Site
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.website.general.update') }}" method="POST">
                @csrf
                
                <!-- Colors Section -->
                <h5 class="mb-3">Color Scheme</h5>
                <div class="row g-4 mb-5">
                    <div class="col-md-6">
                        <label class="form-label">Primary Color <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="color" class="form-control form-control-color @error('primary_color') is-invalid @enderror" name="primary_color" value="{{ old('primary_color', $settings->primary_color) }}" required>
                            <input type="text" class="form-control" value="{{ old('primary_color', $settings->primary_color) }}" readonly>
                        </div>
                        @error('primary_color')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Used for buttons, links, and accents</div>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Secondary Color <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="color" class="form-control form-control-color @error('secondary_color') is-invalid @enderror" name="secondary_color" value="{{ old('secondary_color', $settings->secondary_color) }}" required>
                            <input type="text" class="form-control" value="{{ old('secondary_color', $settings->secondary_color) }}" readonly>
                        </div>
                        @error('secondary_color')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Used for text and subtle elements</div>
                    </div>
                </div>

                <!-- SEO Section -->
                <h5 class="mb-3">SEO Settings</h5>
                <div class="row g-4 mb-5">
                    <div class="col-12">
                        <label class="form-label">Meta Description</label>
                        <textarea class="form-control @error('meta_description') is-invalid @enderror" name="meta_description" rows="3" placeholder="Brief description for search engines (155 characters recommended)">{{ old('meta_description', $settings->meta_description) }}</textarea>
                        @error('meta_description')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Appears in Google search results</div>
                    </div>

                    <div class="col-12">
                        <label class="form-label">Meta Keywords</label>
                        <input type="text" class="form-control @error('meta_keywords') is-invalid @enderror" name="meta_keywords" value="{{ old('meta_keywords', $settings->meta_keywords) }}" placeholder="hostel, accommodation, students, rooms">
                        @error('meta_keywords')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Comma-separated keywords</div>
                    </div>
                </div>

                <!-- Custom Code Section -->
                <h5 class="mb-3">Advanced Customization</h5>
                <div class="row g-4 mb-4">
                    <div class="col-12">
                        <div class="alert alert-warning">
                            <i class="ri-alert-line me-2"></i>
                            <strong>Advanced Users Only:</strong> Incorrect code may break your website. Test carefully.
                        </div>
                    </div>

                    <div class="col-12">
                        <label class="form-label">Custom CSS</label>
                        <textarea class="form-control @error('custom_css') is-invalid @enderror" name="custom_css" rows="6" placeholder="/* Your custom CSS here... */" style="font-family: monospace;">{{ old('custom_css', $settings->custom_css) }}</textarea>
                        @error('custom_css')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Add custom styles to override default design</div>
                    </div>

                    <div class="col-12">
                        <label class="form-label">Custom JavaScript</label>
                        <textarea class="form-control @error('custom_js') is-invalid @enderror" name="custom_js" rows="6" placeholder="// Your custom JavaScript here..." style="font-family: monospace;">{{ old('custom_js', $settings->custom_js) }}</textarea>
                        @error('custom_js')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Add custom scripts or tracking codes (Google Analytics, etc.)</div>
                    </div>
                </div>

                <!-- Submit -->
                <div class="row">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-save-line me-1"></i>Save Changes
                        </button>
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('page-script')
<script>
// Sync color picker with text input
document.querySelectorAll('input[type="color"]').forEach(function(colorInput) {
    const textInput = colorInput.parentElement.querySelector('input[type="text"]');
    colorInput.addEventListener('input', function() {
        textInput.value = this.value;
    });
});
</script>
@endsection
