@extends('layouts/contentNavbarLayout')

@section('title', 'Hero Section - Website')

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0">Hero Section Settings</h4>
        <a href="{{ route('home') }}" class="btn btn-outline-primary" target="_blank">
            <i class="ri-eye-line me-1"></i>Preview Site
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.website.hero.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <div class="row g-4">
                    <!-- Hero Title -->
                    <div class="col-12">
                        <label class="form-label">Hero Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('hero_title') is-invalid @enderror" name="hero_title" value="{{ old('hero_title', $settings->hero_title) }}" required placeholder="Gurudev Hostel">
                        @error('hero_title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Main heading displayed on homepage banner</div>
                    </div>

                    <!-- Hero Subtitle -->
                    <div class="col-12">
                        <label class="form-label">Hero Subtitle</label>
                        <textarea class="form-control @error('hero_subtitle') is-invalid @enderror" name="hero_subtitle" rows="3" placeholder="Your tagline or description...">{{ old('hero_subtitle', $settings->hero_subtitle) }}</textarea>
                        @error('hero_subtitle')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Subheading/description below the title</div>
                    </div>

                    <!-- Background Image -->
                    <div class="col-md-6">
                        <label class="form-label">Background Image</label>
                        @if($settings->hero_background_image)
                            <div class="mb-3">
                                <img src="{{ asset('storage/' . $settings->hero_background_image) }}" alt="Current Background" class="img-thumbnail" style="max-height: 200px;">
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" name="remove_background" value="1" id="removeBackground">
                                    <label class="form-check-label" for="removeBackground">
                                        Remove current background image
                                    </label>
                                </div>
                            </div>
                        @endif
                        <input type="file" class="form-control @error('hero_background_image') is-invalid @enderror" name="hero_background_image" accept="image/*">
                        @error('hero_background_image')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Recommended: 1920x1080px (JPG/PNG, Max 2MB)</div>
                    </div>

                    <!-- Background Color -->
                    <div class="col-md-6">
                        <label class="form-label">Background Color/Gradient</label>
                        <input type="color" class="form-control @error('hero_background_color') is-invalid @enderror" name="hero_background_color" value="{{ old('hero_background_color', $settings->hero_background_color) }}">
                        @error('hero_background_color')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Used if no background image</div>
                    </div>

                    <!-- Button Text -->
                    <div class="col-md-6">
                        <label class="form-label">Button Text <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('hero_button_text') is-invalid @enderror" name="hero_button_text" value="{{ old('hero_button_text', $settings->hero_button_text) }}" required placeholder="Get In Touch">
                        @error('hero_button_text')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <!-- Button Link -->
                    <div class="col-md-6">
                        <label class="form-label">Button Link <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('hero_button_link') is-invalid @enderror" name="hero_button_link" value="{{ old('hero_button_link', $settings->hero_button_link) }}" required placeholder="#contact">
                        @error('hero_button_link')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        <div class="form-text">Use #contact for scroll to contact, or full URL</div>
                    </div>

                    <!-- Submit -->
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-save-line me-1"></i>Save Changes
                        </button>
                        <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
