@extends('layouts/contentNavbarLayout')

@section('title', 'Custom Page Management')

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1">Custom Page Management</h4>
            <p class="text-muted mb-0">Manage custom pages for your application</p>
        </div>
        <button type="button" class="btn btn-primary">
            <i class="ti ti-plus me-1"></i> Add Custom Page
        </button>
    </div>

    <!-- Info Card -->
    <div class="card">
        <div class="card-body">
            <div class="alert alert-info mb-0">
                <h5 class="alert-heading mb-2">
                    <i class="ti ti-info-circle me-2"></i>Custom Page Management Coming Soon
                </h5>
                <p class="mb-2">This feature is currently under development. It will allow you to:</p>
                <ul class="mb-0">
                    <li>Create and manage custom pages</li>
                    <li>Define page slugs and content</li>
                    <li>Set page status (active/inactive)</li>
                    <li>Organize pages for menu linking</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Current Custom Pages -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="card-title mb-0">Current Custom Pages</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Page ID</th>
                            <th>Page Slug</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $customPages = \App\Models\CustomPageModel::all();
                        @endphp
                        @forelse($customPages as $page)
                            <tr>
                                <td>{{ $page->id }}</td>
                                <td>{{ $page->page_id }}</td>
                                <td>
                                    <code>{{ $page->page_slug }}</code>
                                </td>
                                <td>
                                    @if($page->status)
                                        <span class="badge bg-label-success">Active</span>
                                    @else
                                        <span class="badge bg-label-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $page->created_at->format('M d, Y') }}</td>
                                <td>
                                    <button class="btn btn-sm btn-icon btn-label-primary" data-bs-toggle="tooltip" title="Edit">
                                        <i class="ti ti-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-icon btn-label-danger" data-bs-toggle="tooltip" title="Delete">
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center text-muted py-4">
                                    <i class="ti ti-file-off ti-lg mb-2"></i>
                                    <p class="mb-0">No custom pages found. Run the seeder to create sample pages.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Quick Actions Card -->
    <div class="card mt-4">
        <div class="card-header">
            <h5 class="card-title mb-0">Quick Actions</h5>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <div class="d-flex align-items-center p-3 border rounded">
                        <div class="flex-shrink-0 me-3">
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-primary">
                                    <i class="ti ti-database ti-md"></i>
                                </span>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Run Seeder</h6>
                            <small class="text-muted">Create sample custom pages</small>
                            <div class="mt-2">
                                <code class="d-block small">php artisan db:seed --class=CustomPagesSeeder</code>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center p-3 border rounded">
                        <div class="flex-shrink-0 me-3">
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-success">
                                    <i class="ti ti-menu-2 ti-md"></i>
                                </span>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Menu Management</h6>
                            <small class="text-muted">Link pages to menus</small>
                            <div class="mt-2">
                                <a href="{{ route('admin.content-menu_management') }}" class="btn btn-sm btn-outline-success">
                                    Go to Menu Management
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="d-flex align-items-center p-3 border rounded">
                        <div class="flex-shrink-0 me-3">
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-info">
                                    <i class="ti ti-book ti-md"></i>
                                </span>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Documentation</h6>
                            <small class="text-muted">View system docs</small>
                            <div class="mt-2">
                                <span class="badge bg-label-info">Check project root</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
