@php
    $submenus = !empty($menu->submenus) ? (is_string($menu->submenus) ? json_decode($menu->submenus, true) : $menu->submenus) : [];
    $submenuCount = is_array($submenus) ? count($submenus) : 0;
    
    // Calculate total nested submenus recursively using anonymous function
    $countNestedSubmenus = function($submenus) use (&$countNestedSubmenus) {
        $count = count($submenus);
        foreach ($submenus as $submenu) {
            if (isset($submenu['submenus']) && is_array($submenu['submenus'])) {
                $count += $countNestedSubmenus($submenu['submenus']);
            }
        }
        return $count;
    };
    
    $totalSubmenuCount = $countNestedSubmenus($submenus);
@endphp

<div class="menu-list-item" data-menu-id="{{ $menu->id }}" data-order="{{ $menu->order }}">
    <div class="menu-header">
        <!-- Drag Handle -->
        <div class="drag-handle">
            <i class="ti ti-grip-vertical"></i>
        </div>

        <!-- Menu Content -->
        <div class="menu-content flex-grow-1">
            <div class="menu-title">
                <span class="fw-bold">{{ $menu->title_text }}</span>
                <small class="text-muted ms-2">({{ $menu->title }})</small>
            </div>
            <div class="menu-info">
                <span class="badge badge-link-type bg-label-{{ $menu->link_type === 'custom_page' ? 'primary' : ($menu->link_type === 'link_url' ? 'info' : 'secondary') }}">
                    {{ ucfirst(str_replace('_', ' ', $menu->link_type)) }}
                </span>
                
                @if($menu->link_type === 'custom_page' && $menu->custom_page)
                    <small class="text-muted">
                        <i class="ti ti-link ti-xs"></i> {{ $menu->custom_page }}
                    </small>
                @elseif($menu->link_type === 'link_url' && $menu->link_url)
                    <small class="text-muted">
                        <i class="ti ti-external-link ti-xs"></i> 
                        <a href="{{ $menu->link_url }}" target="_blank" class="text-muted">{{ Str::limit($menu->link_url, 40) }}</a>
                    </small>
                @else
                    <small class="text-muted">
                        <i class="ti ti-square-dot ti-xs"></i> No link (placeholder)
                    </small>
                @endif
                
                <span class="badge bg-label-secondary">
                    <i class="ti ti-list-numbers ti-xs"></i> Order: {{ $menu->order }}
                </span>
                
                @if($totalSubmenuCount > 0)
                    <span class="badge bg-label-success" 
                          data-bs-toggle="collapse" 
                          data-bs-target="#submenus-{{ $menu->id }}" 
                          style="cursor: pointer;">
                        <i class="ti ti-menu-2 ti-xs"></i> {{ $totalSubmenuCount }} Submenu(s)
                    </span>
                @endif
            </div>
        </div>

        <!-- Status Toggle -->
        <div class="me-2">
            <label class="status-toggle mb-0">
                <input type="checkbox" 
                       class="status-toggle-input" 
                       data-menu-id="{{ $menu->id }}" 
                       {{ $menu->is_active ? 'checked' : '' }}>
                <span class="status-slider"></span>
            </label>
        </div>

        <!-- Actions -->
        <div class="menu-actions">
            <button type="button" 
                    class="btn btn-sm btn-icon btn-label-primary edit-menu-btn" 
                    data-menu-id="{{ $menu->id }}"
                    data-bs-toggle="tooltip" 
                    title="Edit Menu">
                <i class="ti ti-edit"></i>
            </button>

            <button type="button" 
                    class="btn btn-sm btn-icon btn-label-success add-submenu-btn" 
                    data-parent-id="{{ $menu->id }}"
                    data-parent-name="{{ $menu->title_text }}"
                    data-parent-path=""
                    data-bs-toggle="tooltip" 
                    title="Add Submenu">
                <i class="ti ti-plus"></i>
            </button>

            <button type="button" 
                    class="btn btn-sm btn-icon btn-label-info move-menu-btn" 
                    data-menu-id="{{ $menu->id }}"
                    data-menu-name="{{ $menu->title_text }}"
                    data-bs-toggle="tooltip" 
                    title="Move Menu">
                <i class="ti ti-arrows-move"></i>
            </button>

            <button type="button" 
                    class="btn btn-sm btn-icon btn-label-danger delete-menu-btn" 
                    data-menu-id="{{ $menu->id }}"
                    data-menu-title="{{ $menu->title_text }}"
                    data-submenu-count="{{ $totalSubmenuCount }}"
                    data-bs-toggle="tooltip" 
                    title="Delete Menu">
                <i class="ti ti-trash"></i>
            </button>
        </div>
    </div>

    <!-- Submenus Section -->
    @if($submenuCount > 0)
        <div class="collapse" id="submenus-{{ $menu->id }}">
            <div class="submenu-container">
                <div class="submenu-sortable" data-menu-id="{{ $menu->id }}" data-parent-path="">
                    @foreach($submenus as $submenuIndex => $submenu)
                        @include('content.admin.menu_management.partials.submenu-item', [
                            'submenu' => $submenu,
                            'parentId' => $menu->id,
                            'parentName' => $menu->title_text,
                            'submenuPath' => (string)$submenuIndex,
                            'level' => 1
                        ])
                    @endforeach
                </div>
            </div>
        </div>
    @endif
</div>
