@php
    $hasSubmenus = isset($submenu['submenus']) && is_array($submenu['submenus']) && count($submenu['submenus']) > 0;
    $linkType = $submenu['link_type'] ?? 'placeholder';
    $customPage = $submenu['custom_page'] ?? '';
    $linkUrl = $submenu['link_url'] ?? '';
    $titleText = $submenu['title_text'] ?? '';
    $title = $submenu['title'] ?? '';
    $nestedCount = $hasSubmenus ? count($submenu['submenus']) : 0;
@endphp

<div class="submenu-item" data-submenu-path="{{ $path }}">
    <div class="submenu-header">
        @if($hasSubmenus)
            <button type="button" class="submenu-expand-btn">
                <i class="ri-arrow-right-s-line"></i>
            </button>
        @else
            <span style="width: 24px; display: inline-block;"></span>
        @endif

        <div class="submenu-info">
            <div class="submenu-title-block">
                <div class="submenu-title">{{ $title }}</div>
                <div class="submenu-subtitle">({{ $titleText }})</div>
            </div>

            <div class="submenu-badges">
                @if($linkType === 'custom_page')
                    <span class="badge bg-label-primary">PAGE</span>
                @elseif($linkType === 'link_url')
                    <span class="badge bg-label-info">LINK</span>
                @else
                    <span class="badge bg-label-secondary">PLACEHOLDER</span>
                @endif

                @if($hasSubmenus)
                    <span class="badge bg-label-danger">{{ $nestedCount }} NESTING</span>
                @endif
            </div>
        </div>

        <div class="submenu-actions">
            <button type="button" class="btn btn-sm btn-icon btn-outline-secondary edit-submenu-btn" 
                    data-parent-id="{{ $menuId }}"
                    data-submenu-path="{{ $path }}"
                    data-title="{{ $title }}"
                    data-title-text="{{ $titleText }}"
                    data-link-type="{{ $linkType }}"
                    data-custom-page="{{ $customPage }}"
                    data-link-url="{{ $linkUrl }}"
                    title="Edit">
                <i class="ri-edit-line"></i>
            </button>

            <button type="button" class="btn btn-sm btn-icon btn-outline-info duplicate-submenu-btn" 
                    data-parent-id="{{ $menuId }}"
                    data-submenu-path="{{ $path }}"
                    title="Duplicate">
                <i class="ri-file-copy-line"></i>
            </button>

            @if($level < 5)
                <button type="button" class="btn btn-sm btn-icon btn-outline-success add-submenu-btn" 
                        data-menu-id="{{ $menuId }}"
                        data-parent-path="{{ $path }}"
                        data-menu-name="{{ $menuTitle }} → {{ $titleText }}"
                        title="Add Nested">
                    <i class="ri-add-line"></i>
                </button>
            @endif

            <button type="button" class="btn btn-sm btn-icon btn-outline-danger delete-submenu-btn" 
                    data-parent-id="{{ $menuId }}"
                    data-submenu-path="{{ $path }}"
                    data-submenu-title="{{ $titleText }}"
                    title="Delete">
                <i class="ri-delete-bin-line"></i>
            </button>
        </div>
    </div>

    @if($hasSubmenus)
        <div class="submenu-nested-list">
            @foreach($submenu['submenus'] as $nestedIndex => $nestedSubmenu)
                @include('content.admin.menu_management.partials.submenu-detail-item', [
                    'submenu' => $nestedSubmenu,
                    'menuId' => $menuId,
                    'menuTitle' => $menuTitle . ' → ' . $titleText,
                    'path' => $path . '.' . $nestedIndex,
                    'level' => $level + 1
                ])
            @endforeach
        </div>
    @endif
</div>
