@php
    $hasSubmenus = isset($submenu['submenus']) && is_array($submenu['submenus']) && count($submenu['submenus']) > 0;
    $submenuId = $parentId . '-' . str_replace('.', '-', $submenuPath);
    $linkType = $submenu['link_type'] ?? 'placeholder';
    $customPage = $submenu['custom_page'] ?? '';
    $linkUrl = $submenu['link_url'] ?? '';
@endphp

<div class="submenu-sortable-item submenu-level-{{ $level }}" 
     data-submenu-path="{{ $submenuPath }}"
     data-parent-id="{{ $parentId }}">
    
    <div class="submenu-header">
        <!-- Drag Handle -->
        <div class="drag-handle">
            <i class="ti ti-grip-vertical"></i>
        </div>

        <!-- Collapse Toggle (if has submenus) -->
        @if($hasSubmenus)
            <div class="collapse-toggle" 
                 data-bs-toggle="collapse" 
                 data-bs-target="#submenu-children-{{ $submenuId }}"
                 style="cursor: pointer;">
                <i class="ti ti-chevron-down"></i>
            </div>
        @else
            <div style="width: 24px;"></div>
        @endif

        <!-- Submenu Content -->
        <div class="flex-grow-1 ms-2">
            <div class="d-flex align-items-center gap-2 flex-wrap">
                <span class="fw-semibold">{{ $submenu['title_text'] ?? '' }}</span>
                <small class="text-muted">({{ $submenu['title'] ?? '' }})</small>
                
                <span class="badge badge-link-type bg-label-{{ $linkType === 'custom_page' ? 'primary' : ($linkType === 'link_url' ? 'info' : 'secondary') }}">
                    {{ ucfirst(str_replace('_', ' ', $linkType)) }}
                </span>
                
                @if($linkType === 'custom_page' && $customPage)
                    <small class="text-muted">
                        <i class="ti ti-link ti-xs"></i> {{ $customPage }}
                    </small>
                @elseif($linkType === 'link_url' && $linkUrl)
                    <small class="text-muted">
                        <i class="ti ti-external-link ti-xs"></i> 
                        <a href="{{ $linkUrl }}" target="_blank" class="text-muted">{{ Str::limit($linkUrl, 30) }}</a>
                    </small>
                @endif

                @if($hasSubmenus)
                    <span class="badge bg-label-success badge-sm">
                        <i class="ti ti-menu-2 ti-xs"></i> {{ count($submenu['submenus']) }}
                    </span>
                @endif
            </div>
        </div>

        <!-- Submenu Actions -->
        <div class="d-flex gap-1">
            <button type="button" 
                    class="btn btn-xs btn-icon btn-label-primary edit-submenu-btn" 
                    data-parent-id="{{ $parentId }}"
                    data-parent-name="{{ $parentName }}"
                    data-submenu-path="{{ $submenuPath }}"
                    data-title="{{ $submenu['title'] ?? '' }}"
                    data-title-text="{{ $submenu['title_text'] ?? '' }}"
                    data-link-type="{{ $linkType }}"
                    data-custom-page="{{ $customPage }}"
                    data-link-url="{{ $linkUrl }}"
                    data-bs-toggle="tooltip" 
                    title="Edit">
                <i class="ti ti-edit"></i>
            </button>

            @if($level < 5)
                <button type="button" 
                        class="btn btn-xs btn-icon btn-label-success add-submenu-btn" 
                        data-parent-id="{{ $parentId }}"
                        data-parent-name="{{ $parentName }} → {{ $submenu['title_text'] ?? '' }}"
                        data-parent-path="{{ $submenuPath }}"
                        data-bs-toggle="tooltip" 
                        title="Add Nested">
                    <i class="ti ti-plus"></i>
                </button>
            @endif

            <button type="button" 
                    class="btn btn-xs btn-icon btn-label-info move-submenu-btn" 
                    data-parent-id="{{ $parentId }}"
                    data-parent-name="{{ $parentName }}"
                    data-submenu-path="{{ $submenuPath }}"
                    data-submenu-name="{{ $submenu['title_text'] ?? '' }}"
                    data-bs-toggle="tooltip" 
                    title="Move">
                <i class="ti ti-arrows-move"></i>
            </button>

            <button type="button" 
                    class="btn btn-xs btn-icon btn-label-danger delete-submenu-btn" 
                    data-parent-id="{{ $parentId }}"
                    data-submenu-path="{{ $submenuPath }}"
                    data-submenu-title="{{ $submenu['title_text'] ?? '' }}"
                    data-bs-toggle="tooltip" 
                    title="Delete">
                <i class="ti ti-trash"></i>
            </button>
        </div>
    </div>

    <!-- Nested Submenus (Recursive) -->
    @if($hasSubmenus)
        <div class="collapse" id="submenu-children-{{ $submenuId }}">
            <div class="submenu-sortable mt-2" data-menu-id="{{ $parentId }}" data-parent-path="{{ $submenuPath }}">
                @foreach($submenu['submenus'] as $nestedIndex => $nestedSubmenu)
                    @include('content.admin.menu_management.partials.submenu-item', [
                        'submenu' => $nestedSubmenu,
                        'parentId' => $parentId,
                        'parentName' => $parentName . ' → ' . ($submenu['title_text'] ?? ''),
                        'submenuPath' => $submenuPath . '.' . $nestedIndex,
                        'level' => $level + 1
                    ])
                @endforeach
            </div>
        </div>
    @endif
</div>
