@php
    $hasSubmenus = isset($submenu['submenus']) && is_array($submenu['submenus']) && count($submenu['submenus']) > 0;
    $linkType = $submenu['link_type'] ?? 'placeholder';
    $customPage = $submenu['custom_page'] ?? '';
    $linkUrl = $submenu['link_url'] ?? '';
    $titleText = $submenu['title_text'] ?? '';
    $title = $submenu['title'] ?? '';
@endphp

<tr class="submenu-row submenu-item-row" data-parent-menu-id="{{ $menuId }}" data-submenu-path="{{ $path }}" style="display: none;">
    <td class="submenu-drag-handle text-center" style="cursor: move;">
        <i class="ri-draggable" style="color: #8592a3; font-size: 0.9rem;"></i>
    </td>
    <td></td>
    <td class="submenu-indent-{{ $level }}">
        @if($hasSubmenus)
            <button class="btn btn-xs btn-link submenu-toggle p-0 me-2" data-menu-id="{{ $menuId }}" data-path="{{ $path }}">
                <i class="ri-arrow-down-s-line"></i>
            </button>
        @else
            <span class="me-3"></span>
        @endif
        <span class="fw-semibold">{{ $titleText }}</span>
        <small class="text-muted ms-1">({{ $title }})</small>
    </td>
    <td>
        <span class="badge bg-label-{{ $linkType === 'custom_page' ? 'primary' : ($linkType === 'link_url' ? 'info' : 'secondary') }} badge-sm">
            {{ ucfirst(str_replace('_', ' ', $linkType)) }}
        </span>
    </td>
    <td>
        @if($linkType === 'custom_page')
            <code class="small">{{ $customPage }}</code>
        @elseif($linkType === 'link_url')
            <a href="{{ $linkUrl }}" target="_blank" class="text-info small">{{ Str::limit($linkUrl, 30) }}</a>
        @else
            <span class="text-muted">-</span>
        @endif
    </td>
    <td>
        <span class="badge bg-label-success badge-sm">Submenu</span>
    </td>
    <td>
        @if($hasSubmenus)
            <button class="btn btn-xs btn-label-success submenu-toggle" data-menu-id="{{ $menuId }}" data-path="{{ $path }}">
                <i class="ri-arrow-down-s-line"></i> {{ count($submenu['submenus']) }}
            </button>
        @else
            <span class="text-muted">-</span>
        @endif
    </td>
    <td>
        <button type="button" class="btn btn-xs btn-outline-secondary edit-submenu-btn" 
                data-parent-id="{{ $menuId }}"
                data-submenu-path="{{ $path }}"
                data-title="{{ $title }}"
                data-title-text="{{ $titleText }}"
                data-link-type="{{ $linkType }}"
                data-custom-page="{{ $customPage }}"
                data-link-url="{{ $linkUrl }}"
                title="Edit Submenu">
            <i class="ri-edit-line"></i>
        </button>
        @if($level < 5)
            <button type="button" class="btn btn-xs btn-outline-success add-nested-submenu-btn" 
                    data-menu-id="{{ $menuId }}"
                    data-parent-path="{{ $path }}"
                    data-menu-name="{{ $menuTitle }} → {{ $titleText }}"
                    title="Add Nested Submenu">
                <i class="ri-add-line"></i>
            </button>
        @endif
        <button type="button" class="btn btn-xs btn-outline-info move-submenu-to-menu-btn" 
                data-parent-id="{{ $menuId }}"
                data-submenu-path="{{ $path }}"
                data-submenu-title="{{ $titleText }}"
                title="Move to Main Menu">
            <i class="ri-arrow-left-up-line"></i>
        </button>
        <button type="button" class="btn btn-xs btn-outline-danger delete-submenu-btn" 
                data-parent-id="{{ $menuId }}"
                data-submenu-path="{{ $path }}"
                data-submenu-title="{{ $titleText }}"
                title="Delete Submenu">
            <i class="ri-delete-bin-line"></i>
        </button>
    </td>
</tr>

<!-- Nested Submenus (Recursive) -->
@if($hasSubmenus)
    @foreach($submenu['submenus'] as $nestedIndex => $nestedSubmenu)
        @include('content.admin.menu_management.partials.submenu-row', [
            'submenu' => $nestedSubmenu,
            'menuId' => $menuId,
            'menuTitle' => $menuTitle . ' → ' . $titleText,
            'path' => $path . '.' . $nestedIndex,
            'level' => $level + 1
        ])
    @endforeach
@endif
