@php
use Illuminate\Support\Facades\Route;
@endphp

<ul class="menu-sub">
  @if (isset($menu))
    @foreach ($menu as $submenu)

    {{-- active menu method --}}
    @php
      $activeClass = null;
      $active = 'active open';
      $currentRouteName = Route::currentRouteName();
      $isRouteName = isset($submenu->url) && str_contains($submenu->url ?? '', '.') && !str_starts_with($submenu->url ?? '', 'http');

      if ($isRouteName && request()->routeIs($submenu->url)) {
        $activeClass = 'active';
      } elseif ($currentRouteName === ($submenu->slug ?? null)) {
        $activeClass = 'active';
      } elseif (isset($submenu->submenu)) {
        if (gettype($submenu->slug ?? null) === 'array') {
          foreach ($submenu->slug as $slug) {
            if (str_contains($currentRouteName, $slug) && strpos($currentRouteName, $slug) === 0) {
              $activeClass = $active;
            }
          }
        } else {
          if (isset($submenu->slug) && str_contains($currentRouteName, $submenu->slug) && strpos($currentRouteName, $submenu->slug) === 0) {
            $activeClass = $active;
          }
        }
      }
    @endphp

    @php
      $href = isset($submenu->url) ? ($isRouteName ? route($submenu->url) : url($submenu->url)) : 'javascript:void(0)';
    @endphp

      <li class="menu-item {{ $activeClass }}">
        <a href="{{ $href }}" class="{{ isset($submenu->submenu) ? 'menu-link menu-toggle' : 'menu-link' }}" @if (isset($submenu->target) && !empty($submenu->target)) target="{{ $submenu->target }}" @endif>
          @if (isset($submenu->icon))
          <i class="{{ $submenu->icon }}"></i>
          @endif
          <div>{{ isset($submenu->name) ? __($submenu->name) : '' }}</div>
          @isset($submenu->badge)
            <div class="badge bg-{{ $submenu->badge[0] }} rounded-pill ms-auto">{{ $submenu->badge[1] }}</div>
          @endisset
        </a>

        {{-- submenu --}}
        @if (isset($submenu->submenu))
          @include('layouts.sections.menu.submenu', ['menu' => $submenu->submenu])
        @endif
      </li>
    @endforeach
  @endif
</ul>
