@php
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
$guard = Route::is('admin.*') ? 'admin' : null;
$currentUser = $guard && Auth::guard($guard)->check() ? Auth::guard($guard)->user() : (Auth::check() ? Auth::user() : null);
$userName = $currentUser ? ($currentUser->name ?? 'Admin') : 'Admin';
$userAvatar = $currentUser && $currentUser->avatar ? asset('storage/' . $currentUser->avatar) : asset('assets/json/img/avatars/1.png');
$brandTextNav = strtoupper(config('variables.templateName'));
@endphp

<!-- Left: SNEAT logo (purple) + vertical separator + light grey left arrow -->
<div class="navbar-nav align-items-center sneat-navbar-left">
    <a href="{{ url('/') }}" class="app-brand-link gap-2 d-flex align-items-center text-nowrap">
        <span class="app-brand-logo demo sneat-logo-inline me-1">@include('_partials.macros')</span>
        <span class="app-brand-text demo sneat-brand-text fw-bold">{{ $brandTextNav }}</span>
    </a>
    <span class="sneat-navbar-separator"></span>
    @if(!isset($navbarHideToggle))
    <a class="layout-menu-toggle nav-link sneat-navbar-arrow ms-2 px-2" href="javascript:void(0)" aria-label="Toggle sidebar">
        <i class="ri ri-arrow-left-s-line"></i>
    </a>
    @endif
</div>

<!-- Right: Bell, Moon, Envelope, Gear, Avatar only -->
<div class="navbar-nav align-items-center ms-auto sneat-navbar-right">
    <ul class="navbar-nav flex-row align-items-center gap-0">
        @if(Route::is('admin.*'))
            @include('components.notifications-dropdown')
        @endif
        <li class="nav-item">
            <a class="nav-link sneat-nav-link px-2 py-1" href="javascript:void(0)" aria-label="Theme">
                <i class="ri ri-moon-line icon-lg"></i>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link sneat-nav-link px-2 py-1" href="javascript:void(0)" aria-label="Messages">
                <i class="ri ri-mail-line icon-lg"></i>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link sneat-nav-link px-2 py-1" href="javascript:void(0)" aria-label="Settings">
                <i class="ri ri-settings-3-line icon-lg"></i>
            </a>
        </li>
        <li class="nav-item navbar-dropdown dropdown-user dropdown">
            <a class="nav-link dropdown-toggle hide-arrow d-flex align-items-center px-2 py-1" href="javascript:void(0);" data-bs-toggle="dropdown">
                <div class="avatar avatar-online">
                    <img src="{{ $userAvatar }}" alt="" class="rounded-circle" />
                </div>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
                <li>
                    <a class="dropdown-item" href="{{ Route::is('admin.*') ? route('admin.profile.edit') : 'javascript:void(0);' }}">
                        <div class="d-flex">
                            <div class="flex-shrink-0 me-3">
                                <div class="avatar avatar-online">
                                    <img src="{{ $userAvatar }}" alt="" class="w-px-40 h-auto rounded-circle" />
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-0">{{ $userName }}</h6>
                                <small class="text-body-secondary">Admin</small>
                            </div>
                        </div>
                    </a>
                </li>
                <li><div class="dropdown-divider my-1"></div></li>
                <li>
                    @if(Route::is('admin.*'))
                    <a class="dropdown-item" href="{{ route('admin.profile.edit') }}">
                        <i class="icon-base ri ri-user-3-line icon-md me-3"></i>
                        <span>My Profile</span>
                    </a>
                    @else
                    <a class="dropdown-item" href="javascript:void(0);">
                        <i class="icon-base ri ri-user-3-line icon-md me-3"></i>
                        <span>My Profile</span>
                    </a>
                    @endif
                </li>
                <li>
                    @if(Route::is('admin.*'))
                    <a class="dropdown-item" href="{{ route('admin.profile.edit', ['tab' => 'security']) }}">
                        <i class="icon-base ri ri-lock-password-line icon-md me-3"></i>
                        <span>Change Password</span>
                    </a>
                    @else
                    <a class="dropdown-item" href="javascript:void(0);">
                        <i class="icon-base ri ri-settings-4-line icon-md me-3"></i>
                        <span>Settings</span>
                    </a>
                    @endif
                </li>
                <li><div class="dropdown-divider my-1"></div></li>
                <li>
                    <div class="d-grid px-4 pt-2 pb-1">
                        @if(Route::is('admin.*'))
                        <form action="{{ route('admin.logout') }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-danger d-flex w-100 align-items-center justify-content-center">
                                <small class="align-middle">Logout</small>
                                <i class="ri ri-logout-box-r-line ms-2 icon-xs"></i>
                            </button>
                        </form>
                        @elseif(Route::is('user.*'))
                        <form action="{{ route('user.logout') }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-danger d-flex w-100 align-items-center justify-content-center">
                                <small class="align-middle">Logout</small>
                                <i class="ri ri-logout-box-r-line ms-2 icon-xs"></i>
                            </button>
                        </form>
                        @else
                        <a class="btn btn-danger d-flex align-items-center justify-content-center" href="javascript:void(0);">
                            <small class="align-middle">Logout</small>
                            <i class="ri ri-logout-box-r-line ms-2 icon-xs"></i>
                        </a>
                        @endif
                    </div>
                </li>
            </ul>
        </li>
    </ul>
</div>
