<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 11px; color: #333; }
        .agreement-page { max-width: 100%; }
        .agreement-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 15px; }
        .agreement-title { font-size: 14px; font-weight: 700; text-transform: uppercase; }
        .agreement-address { font-size: 10px; color: #555; margin-top: 5px; }
        .agreement-table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        .agreement-table td, .agreement-table th { padding: 4px 6px; vertical-align: top; border: none; }
        .agreement-table th { font-weight: 600; width: 32%; color: #333; }
        .rules-list { margin: 5px 0; padding-left: 20px; }
        .rules-list li { margin-bottom: 4px; }
        .signature-block { margin-top: 15px; }
        .signature-block img { max-width: 180px; max-height: 60px; }
        .sig-cell { width: 50%; display: inline-block; vertical-align: top; }
    </style>
</head>
<body>
<div class="agreement-page">
    <div class="agreement-header">
        <div class="agreement-title">{{ config('student_registration.hostel_name', config('app.name')) }}</div>
        <div class="agreement-address">{{ config('student_registration.hostel_address', '') }}</div>
    </div>
    <table class="agreement-table">
        <tr>
            <th>Room No.</th>
            <td>{{ $student->room_bed_identifier ?? ($student->bed?->name ?? '—') }}</td>
            <td style="text-align:right;">
                @php $photo = $student->documents->where('document_type', 'profile_photo')->first(); @endphp
                @if($photo)
                    <img src="{{ $baseUrl }}/storage/{{ $photo->file_path }}" alt="" style="width:90px;height:110px;object-fit:cover;">
                @else
                    <span>No photo</span>
                @endif
            </td>
        </tr>
        <tr><th>Student Full Name</th><td colspan="2">{{ $student->full_name }}</td></tr>
        <tr><th>Student Aadhar Number</th><td colspan="2">{{ $student->aadhar_number ?? '—' }}</td></tr>
        <tr><th>Residential Address</th><td colspan="2">{{ collect([$student->permanent_locality, $student->permanent_taluka, $student->permanent_district, $student->permanent_state])->filter()->implode(', ') ?: '—' }}</td></tr>
        <tr><th>Student's Mobile No.</th><td>{{ $student->student_mobile ?? '—' }}</td><th>Parent's Mobile No.</th><td>{{ $student->parent_mobile ?? '—' }}</td></tr>
        <tr><th>Date of Birth</th><td>{{ $student->date_of_birth?->format('d/m/Y') ?? '—' }}</td><th>Standard / Stream</th><td>{{ $student->standard_year ?? '—' }} / {{ $student->stream ?? '—' }}</td></tr>
        <tr><th>College Name</th><td colspan="2">{{ $student->college_name ?? '—' }}</td></tr>
        <tr><th>College In / Out Timing</th><td colspan="2">{{ $student->college_in_time ?? '—' }} / {{ $student->college_out_time ?? '—' }}</td></tr>
        <tr><th>Date of Admission</th><td>{{ $admissionDate?->format('d/m/Y') ?? '—' }}</td><th>Hostel Leaving Date</th><td>{{ $leavingDate?->format('d/m/Y') ?? '—' }}</td></tr>
    </table>
    <h5 style="margin-top:15px;"><u>Rules &amp; Regulations:</u></h5>
    <ol class="rules-list">
        <li>It is mandatory to fill up the admission form by submitting 3 passport size photo/Aadhar card/Election card/TC Xerox (along with the Aadhar Card of parents if required).</li>
        <li>It is compulsory to pay deposit.</li>
        <li>Advance rent of month to be paid initially in first five days of month, if not deposited then fine of Rs.20/- per day will be charged until the date students pay the fees.</li>
        <li>Rent and deposit will not be refunded for any reason even if the admission to be cancelled within one day.</li>
        <li>Deposit will be refunded only after the student completes an academic year.</li>
        <li>The right to deny access without any reason will be reserved.</li>
        <li>If parents want to meet then they should take permission from the office.</li>
        <li>Friends, relatives are not allowed to stay in the room.</li>
        <li>Tiffin/food parcel are not allowed inside the hostel room.</li>
        <li>Smoking, alcohol, tobacco, non-veg, alcoholic beverages are strictly prohibited in hostel room.</li>
        <li>A fine of Rs.500/- will be taken for destroying hostel property, spitting on the wall. Deposit will not be refunded.</li>
        <li>If students want to go home/vacation, then they should submit the application before leaving.</li>
        <li>Students should arrive by 9:30 pm. No one will be allowed after the gate is closed.</li>
        <li>The entire right to change the room or beds will be reserved and changed from time to time as per rules of the hostel.</li>
        <li>Rooms to be cleaned alternately by the students.</li>
        <li>Garbage to be dumped in the dustbin or else fine of Rs.200/- to be paid.</li>
        <li>Electric fans, lights, water taps should be turned off while not in use or else fine of Rs.200/- will be charged by double locking the room.</li>
        <li>Students misbehaviour will not be tolerated in the hostel.</li>
        <li>If there is any dispute between the students, then inform the manager, do not quarrel with each other.</li>
        <li>Electric appliances like heater, induction gas, press is not allowed or else fine of Rs.500 will be charged and appliances will be confiscated.</li>
        <li>It is strictly prohibited to carry sharp weapons, cricket bats, stumps, tools that could injure one self to others.</li>
        <li>If the student has any simple or serious illness, it is necessary to take timely medication. Hostel management will not be responsible.</li>
        <li>Rooms to be kept open on Sunday so that toilet cleaning can be done properly.</li>
        <li>Deposited amount will not be credited to the rent.</li>
        <li>Students should not make crowd within hostel campus.</li>
        <li>Solar (hot) water is available up to 9 am in morning as per environment.</li>
        <li>Students are not allowed to put on their own lock; if found will be broken.</li>
        <li>Students should keep their valuable things on their responsibility. Hostel management will not be responsible for it.</li>
    </ol>
    <p style="margin-top:12px;">I have read all the above terms and conditions and I agree to follow them. Violation will result in punishment and admission may be revoked. I understand that admission is required for at least one year and that if I leave in the middle, rent and deposit will not be refunded.</p>
    <p style="margin-top:8px;">My date of admission in hostel is from <strong>{{ $admissionDate?->format('d/m/Y') ?? '—' }}</strong> to <strong>{{ $leavingDate?->format('d/m/Y') ?? '—' }}</strong>. I am signing this realizing.</p>
    <div class="signature-block">
        <div class="sig-cell">
            <label style="display:block;font-size:10px;font-weight:600;">Parent's Signature</label>
            @php $psign = $student->documents->where('document_type', 'parent_signature')->first(); @endphp
            @if($psign)
                <img src="{{ $baseUrl }}/storage/{{ $psign->file_path }}" alt="">
            @else
                <span>—</span>
            @endif
        </div>
        <div class="sig-cell" style="text-align:right;">
            <label style="display:block;font-size:10px;font-weight:600;">Student Signature</label>
            @php $ssign = $student->documents->where('document_type', 'student_signature')->first(); @endphp
            @if($ssign)
                <img src="{{ $baseUrl }}/storage/{{ $ssign->file_path }}" alt="">
            @else
                <span>—</span>
            @endif
        </div>
    </div>
</div>
</body>
</html>
