<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\DashboardController as UserDashboardController;
use App\Http\Controllers\User\Auth\LoginController as UserLoginController;
use App\Http\Controllers\User\Auth\VerifyOtpController as UserVerifyOtpController;

/*
|--------------------------------------------------------------------------
| User Routes
|--------------------------------------------------------------------------
| User panel routes. Loaded with prefix 'user' and name prefix 'user.'
| from bootstrap/app.php.
*/

// Login (controller redirects if already authenticated)
Route::get('/login', [UserLoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [UserLoginController::class, 'login'])->middleware('throttle:5,1');

// Auth required but OTP not yet verified: verify OTP & resend
Route::middleware('auth:user')->group(function () {
    Route::get('/verify-otp', [UserVerifyOtpController::class, 'showVerifyForm'])->name('verify-otp');
    Route::post('/verify-otp', [UserVerifyOtpController::class, 'verify']);
    Route::post('/resend-otp', [UserVerifyOtpController::class, 'resend'])->name('resend-otp');
    Route::post('/logout', [UserLoginController::class, 'logout'])->name('logout');
});

// Protected user routes: auth → OTP verified (no-cache so back button redirects to login)
Route::middleware(['auth.user', 'otp.verified:user', 'prevent.back.history'])->group(function () {
    Route::get('/', [UserDashboardController::class, 'index'])->name('dashboard');
});
