<style>
@media print { 
    body { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
    .modal-header, .modal-footer { display: none !important; }
    .modal-body { padding: 0 !important; }
}
.receipt { font-family: system-ui, sans-serif; }
.receipt-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 1rem; margin-bottom: 1.5rem; }
.receipt-title { font-size: 1.5rem; font-weight: 700; text-transform: uppercase; }
.receipt-meta { font-size: 0.875rem; color: #555; margin-top: 0.5rem; }
.receipt-table { width: 100%; border-collapse: collapse; margin: 1rem 0; }
.receipt-table th, .receipt-table td { padding: 0.5rem 0.75rem; text-align: left; border-bottom: 1px solid #dee2e6; }
.receipt-table th { font-weight: 600; width: 40%; color: #495057; }
.amount-words { font-style: italic; padding: 0.5rem; background: #f8f9fa; border-radius: 0.25rem; }
.receipt-footer { margin-top: 2rem; text-align: center; font-size: 0.8125rem; color: #6c757d; }
</style>

<div class="receipt">
    <div class="receipt-header">
        <div class="receipt-title"><?php echo e(hostel_name()); ?></div>
        <div class="receipt-meta">Deposit Return Receipt</div>
    </div>

    <table class="receipt-table">
        <tr><th>Return Ref.</th><td>DR-<?php echo e($depositReturn->id); ?></td></tr>
        <tr><th>Return Date</th><td><?php echo e($depositReturn->return_date?->format('d/m/Y') ?? '—'); ?></td></tr>
        <tr><th>Student ID</th><td><?php echo e($depositReturn->student_id); ?></td></tr>
        <tr><th>Student Name</th><td><?php echo e($depositReturn->student->full_name ?? '—'); ?></td></tr>
        <tr><th>Refund Amount (₹)</th><td><?php echo e(number_format($depositReturn->amount_returned, 2)); ?></td></tr>
        <tr><th>Amount in Words</th><td><div class="amount-words"><?php echo e($amountInWords ?? '—'); ?></div></td></tr>
        <tr><th>Mode of Refund</th><td><?php echo e(\Illuminate\Support\Arr::get(config('student_registration.payment_modes', []), $depositReturn->payment_mode, $depositReturn->payment_mode)); ?></td></tr>
        <?php if($depositReturn->transaction_id): ?>
            <tr><th>UTR / Reference</th><td><?php echo e($depositReturn->transaction_id); ?></td></tr>
        <?php endif; ?>
        <?php if($depositReturn->notes): ?>
            <tr><th>Notes</th><td><?php echo e($depositReturn->notes); ?></td></tr>
        <?php endif; ?>
    </table>

    <div class="receipt-footer">This is a computer-generated receipt. Deposit refund issued.</div>
</div>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/receipts/_deposit_return_content.blade.php ENDPATH**/ ?>