<?php $__env->startSection('title', 'Reports'); ?>

<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss']); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
        <h4 class="fw-bold py-3 mb-0">Analysis &amp; Reports</h4>
        <a href="<?php echo e(route('admin.reports.period', request()->only(['from_date', 'to_date']))); ?>" class="btn btn-outline-primary btn-sm">
            <i class="ri-file-list-3-line me-1"></i>Period Report
        </a>
    </div>

    
    <div class="card mb-4">
        <div class="card-body">
            <form method="get" action="<?php echo e(route('admin.reports.index')); ?>" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="from_date" value="<?php echo e($fromDate); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="to_date" value="<?php echo e($toDate); ?>">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Apply</button>
                    <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn btn-outline-secondary">Reset</a>
                </div>
            </form>
        </div>
    </div>

    
    <div class="row g-4 mb-4">
        <div class="col-sm-6 col-xl-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-3 bg-label-primary text-primary me-3 p-3">
                        <i class="ri-money-rupee-circle-line ri-2x"></i>
                    </div>
                    <div class="flex-grow-1 min-w-0">
                        <p class="text-muted small text-uppercase mb-1 fw-medium">Total Rent</p>
                        <h4 class="mb-0 fw-bold">₹ <?php echo e(number_format($rentTotal, 2)); ?></h4>
                        <a href="<?php echo e(route('admin.receipts.rent', ['from_date' => $fromDate, 'to_date' => $toDate])); ?>" class="small">More Info <i class="ri-arrow-right-line"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-3 bg-label-info text-info me-3 p-3">
                        <i class="ri-bank-card-line ri-2x"></i>
                    </div>
                    <div class="flex-grow-1 min-w-0">
                        <p class="text-muted small text-uppercase mb-1 fw-medium">Total Deposit</p>
                        <h4 class="mb-0 fw-bold">₹ <?php echo e(number_format($depositTotal, 2)); ?></h4>
                        <a href="<?php echo e(route('admin.receipts.deposit', ['from_date' => $fromDate, 'to_date' => $toDate])); ?>" class="small">More Info <i class="ri-arrow-right-line"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-3 bg-label-danger text-danger me-3 p-3">
                        <i class="ri-file-list-3-line ri-2x"></i>
                    </div>
                    <div class="flex-grow-1 min-w-0">
                        <p class="text-muted small text-uppercase mb-1 fw-medium">Total Expense</p>
                        <h4 class="mb-0 fw-bold">₹ <?php echo e(number_format($expenseTotal, 2)); ?></h4>
                        <a href="<?php echo e(route('admin.expenses.index', ['from_date' => $fromDate, 'to_date' => $toDate])); ?>" class="small">More Info <i class="ri-arrow-right-line"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="rounded-3 bg-label-success text-success me-3 p-3">
                        <i class="ri-pie-chart-2-line ri-2x"></i>
                    </div>
                    <div class="flex-grow-1 min-w-0">
                        <p class="text-muted small text-uppercase mb-1 fw-medium">Revenue (Rent + Deposit)</p>
                        <h4 class="mb-0 fw-bold">₹ <?php echo e(number_format($revenueTotal, 2)); ?></h4>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="row g-4 mb-4">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 pb-0">
                    <h5 class="card-title mb-0">Payment Type Trends (Monthly)</h5>
                    <p class="text-muted small mb-0">Rent, Deposit &amp; Expense by month</p>
                </div>
                <div class="card-body pt-2">
                    <div id="paymentTrendChart"
                         data-labels="<?php echo e(json_encode($months)); ?>"
                         data-rent="<?php echo e(json_encode($rentByMonth)); ?>"
                         data-deposit="<?php echo e(json_encode($depositByMonth)); ?>"
                         data-expense="<?php echo e(json_encode($expenseByMonth)); ?>"></div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 pb-0">
                    <h5 class="card-title mb-0">Revenue Share</h5>
                    <p class="text-muted small mb-0">Rent vs Deposit</p>
                </div>
                <div class="card-body pt-2">
                    <div id="revenuePieChart"
                         data-labels="<?php echo e(json_encode($pieLabels)); ?>"
                         data-series="<?php echo e(json_encode($pieSeries)); ?>"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-transparent border-0 pb-0">
                    <h5 class="card-title mb-0">Payment Mode Distribution</h5>
                    <p class="text-muted small mb-0">Revenue (Rent + Deposit) by payment mode in selected period</p>
                </div>
                <div class="card-body pt-2">
                    <div id="paymentModeBarChart"
                         data-labels="<?php echo e(json_encode($modeLabels)); ?>"
                         data-amounts="<?php echo e(json_encode($modeAmounts)); ?>"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
(function() {
  function initCharts() {
    if (typeof ApexCharts === 'undefined') return;
    const labelColor = (typeof config !== 'undefined' && config.colors) ? config.colors.textMuted : '#a1acb8';
    const borderColor = (typeof config !== 'undefined' && config.colors) ? config.colors.borderColor : '#ebeef0';
    const fontFamily = (typeof config !== 'undefined' && config.fontFamily) ? config.fontFamily : 'inherit';

    // Payment type trend (line)
    const trendEl = document.querySelector('#paymentTrendChart');
    if (trendEl) {
      const labels = JSON.parse(trendEl.getAttribute('data-labels') || '[]');
      const rent = JSON.parse(trendEl.getAttribute('data-rent') || '[]');
      const deposit = JSON.parse(trendEl.getAttribute('data-deposit') || '[]');
      const expense = JSON.parse(trendEl.getAttribute('data-expense') || '[]');
      const trendConfig = {
        chart: { type: 'line', height: 300, fontFamily, toolbar: { show: false }, zoom: { enabled: false } },
        series: [
          { name: 'Rent (₹)', data: rent },
          { name: 'Deposit (₹)', data: deposit },
          { name: 'Expense (₹)', data: expense }
        ],
        colors: ['#696cff', '#03c3ec', '#ff6384'],
        stroke: { curve: 'smooth', width: 2 },
        xaxis: {
          categories: labels,
          labels: { style: { colors: labelColor, fontSize: '11px' } },
          axisBorder: { show: false },
          axisTicks: { show: false }
        },
        yaxis: {
          labels: { style: { colors: labelColor }, formatter: function(v) { return '₹' + (v >= 1000 ? (v/1000).toFixed(1) + 'K' : v); } }
        },
        grid: { borderColor, strokeDashArray: 6, padding: { top: -10, bottom: -5, left: 10, right: 10 } },
        legend: { position: 'top', horizontalAlign: 'right', labels: { colors: labelColor } },
        tooltip: { theme: 'light', y: { formatter: function(v) { return '₹ ' + Number(v).toLocaleString('en-IN', { minimumFractionDigits: 2 }); } } }
      };
      new ApexCharts(trendEl, trendConfig).render();
    }

    // Revenue pie
    const pieEl = document.querySelector('#revenuePieChart');
    if (pieEl) {
      const labels = JSON.parse(pieEl.getAttribute('data-labels') || '[]');
      const series = JSON.parse(pieEl.getAttribute('data-series') || '[]');
      const pieConfig = {
        chart: { type: 'donut', height: 280, fontFamily, toolbar: { show: false } },
        labels: labels,
        series: series,
        colors: ['#696cff', '#03c3ec'],
        stroke: { width: 0 },
        dataLabels: { enabled: true, formatter: function(val) { return Math.round(val) + '%'; } },
        legend: { show: true, position: 'bottom', horizontalAlign: 'center', labels: { colors: labelColor } },
        plotOptions: {
          pie: {
            donut: {
              size: '70%',
              labels: {
                show: true,
                name: { show: true, color: labelColor },
                value: { show: true, fontSize: '1.25rem', fontWeight: 600 },
                total: { show: true, label: 'Revenue', formatter: function(w) { return '₹' + w.globals.seriesTotals.reduce(function(a,b) { return a+b; }, 0).toLocaleString('en-IN', { maximumFractionDigits: 0 }); }, color: labelColor }
              }
            }
          }
        }
      };
      new ApexCharts(pieEl, pieConfig).render();
    }

    // Payment mode bar
    const barEl = document.querySelector('#paymentModeBarChart');
    if (barEl) {
      const labels = JSON.parse(barEl.getAttribute('data-labels') || '[]');
      const amounts = JSON.parse(barEl.getAttribute('data-amounts') || '[]');
      if (labels.length && amounts.length) {
        const barConfig = {
          chart: { type: 'bar', height: 280, fontFamily, toolbar: { show: false } },
          plotOptions: { bar: { borderRadius: 6, columnWidth: '60%', distributed: true } },
          series: [{ name: 'Amount (₹)', data: amounts }],
          colors: ['#696cff', '#03c3ec', '#71dd37', '#ffab00', '#ff6384', '#56ca37'],
          xaxis: {
            categories: labels,
            labels: { style: { colors: labelColor, fontSize: '11px' } },
            axisBorder: { show: false },
            axisTicks: { show: false }
          },
          yaxis: {
            labels: { style: { colors: labelColor }, formatter: function(v) { return '₹' + (v >= 1000 ? (v/1000).toFixed(1) + 'K' : v); } }
          },
          grid: { borderColor, strokeDashArray: 6, padding: { top: -10, bottom: -5, left: 10, right: 10 } },
          dataLabels: { enabled: false },
          legend: { show: false },
          tooltip: { theme: 'light', y: { formatter: function(v) { return '₹ ' + Number(v).toLocaleString('en-IN', { minimumFractionDigits: 2 }); } } }
        };
        new ApexCharts(barEl, barConfig).render();
      } else {
        barEl.innerHTML = '<p class="text-muted text-center py-4 mb-0">No payment mode data for the selected period.</p>';
      }
    }
  }
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initCharts);
  } else {
    initCharts();
  }
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/reports/index.blade.php ENDPATH**/ ?>