<?php
use Illuminate\Support\Facades\Route;
$menu = $menuData[0]->menu ?? [];
$brandText = strtoupper(config('variables.templateName'));
?>

<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme sneat-sidebar">

  <!-- SNEAT (purple) + purple circle, separator below -->
  <div class="app-brand demo sneat-app-brand">
    <a href="<?php echo e(url('/')); ?>" class="app-brand-link">
      <span class="app-brand-logo demo me-1 sneat-logo-inline"><?php echo $__env->make('_partials.macros', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?></span>
      <span class="app-brand-text demo menu-text fw-bold ms-2"><?php echo e($brandText); ?></span>
    </a>
    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto sneat-sidebar-circle" aria-label="Toggle sidebar">
      <span class="sneat-circle-icon"></span>
    </a>
  </div>

  <div class="sneat-sidebar-divider"></div>
  <div class="menu-inner-shadow"></div>

  <ul class="menu-inner py-1">
    <?php $__currentLoopData = $menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($item->menuHeader)): ?>
        <li class="menu-header small text-uppercase">
          <span class="menu-header-text"><?php echo e($item->menuHeader); ?></span>
        </li>
      <?php else: ?>
        <?php
          $hasSubmenu = isset($item->submenu) && count($item->submenu) > 0;
          $isRouteName = isset($item->url) && str_contains($item->url, '.') && !str_starts_with($item->url ?? '', 'http');
          $href = isset($item->url) ? ($isRouteName ? route($item->url) : url($item->url)) : 'javascript:void(0);';
          $activeClass = '';
          if ($hasSubmenu) {
            $slugForRoute = isset($item->slug) ? str_replace('-', '.', $item->slug) : '';
            if ($slugForRoute && request()->routeIs($slugForRoute . '.*')) {
              $activeClass = 'active open';
            }
          } else {
            if ($isRouteName && request()->routeIs($item->url)) {
              $activeClass = 'active';
            } elseif (isset($item->slug) && Route::currentRouteName() === $item->slug) {
              $activeClass = 'active';
            }
          }
        ?>
        <li class="menu-item <?php echo e($activeClass); ?>">
          <a href="<?php echo e($href); ?>" class="<?php echo e($hasSubmenu ? 'menu-link menu-toggle' : 'menu-link'); ?>" <?php if(isset($item->target) && $item->target): ?> target="<?php echo e($item->target); ?>" <?php endif; ?>>
            <?php if(isset($item->icon)): ?>
              <i class="<?php echo e($item->icon); ?>"></i>
            <?php endif; ?>
            <div><?php echo e($item->name ?? ''); ?></div>
            <?php if(isset($item->badge)): ?>
              <div class="badge bg-<?php echo e($item->badge[0]); ?> rounded-pill ms-auto"><?php echo e($item->badge[1]); ?></div>
            <?php endif; ?>
          </a>
          <?php if($hasSubmenu): ?>
            <?php echo $__env->make('layouts.sections.menu.submenu', ['menu' => $item->submenu], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
          <?php endif; ?>
        </li>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </ul>

</aside>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/layouts/sections/menu/verticalMenu.blade.php ENDPATH**/ ?>