<?php $__env->startSection('title', 'Account Settings'); ?>

<?php $__env->startSection('vendor-style'); ?>
<style>
.account-settings .nav-pills .nav-link { color: #697a8d; border-radius: 0.375rem; padding: 0.5rem 1rem; }
.account-settings .nav-pills .nav-link.active { color: #fff; background-color: #696cff; font-weight: 600; }
.account-settings .nav-pills .nav-link i { font-size: 1.125rem; }
.account-settings .profile-avatar { width: 100px; height: 100px; border-radius: 0.5rem; overflow: hidden; border: 2px solid var(--bs-border-color); }
.account-settings .profile-avatar img { width: 100%; height: 100%; object-fit: cover; }
.account-settings .password-toggle { cursor: pointer; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y account-settings">
    <h4 class="fw-bold py-3 mb-4">Account Settings</h4>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible" role="alert">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-12">
            <div class="nav-align-top">
                <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-2 gap-lg-0">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e($activeTab === 'account' ? 'active' : ''); ?>" href="<?php echo e(route('admin.profile.edit', ['tab' => 'account'])); ?>">
                            <i class="icon-base ri ri-group-line icon-sm me-1_5"></i>Account
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e($activeTab === 'security' ? 'active' : ''); ?>" href="<?php echo e(route('admin.profile.edit', ['tab' => 'security'])); ?>">
                            <i class="icon-base ri ri-lock-2-line icon-sm me-1_5"></i>Security
                        </a>
                    </li>
                </ul>
            </div>

            <?php if($activeTab === 'account'): ?>
            
            <div class="card mb-6">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.profile.update')); ?>" method="POST" enctype="multipart/form-data" id="accountForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        
                        
                        <div class="d-flex align-items-start align-items-sm-center gap-6 pb-4 border-bottom">
                            <div class="profile-avatar d-block">
                                <?php if($user->avatar): ?>
                                    <img id="profileAvatarImg" src="<?php echo e(asset('storage/' . $user->avatar)); ?>" alt="Avatar">
                                <?php else: ?>
                                    <img id="profileAvatarImg" src="<?php echo e(asset('assets/json/img/avatars/1.png')); ?>" alt="Avatar">
                                <?php endif; ?>
                            </div>
                            <div class="button-wrapper">
                                <label for="avatarInput" class="btn btn-sm btn-primary me-3 mb-4" tabindex="0">
                                    <span class="d-none d-sm-block">Upload new photo</span>
                                    <i class="icon-base ri ri-upload-2-line d-block d-sm-none"></i>
                                    <input type="file" id="avatarInput" name="avatar" class="d-none" accept="image/png,image/jpeg,image/gif" />
                                </label>
                                <button type="button" class="btn btn-sm btn-outline-danger mb-4" id="avatarResetBtn">
                                    <i class="icon-base ri ri-refresh-line d-block d-sm-none"></i>
                                    <span class="d-none d-sm-block">Reset</span>
                                </button>
                                <input type="hidden" name="avatar_remove" id="avatarRemove" value="0">
                                <div class="small">Allowed JPG, GIF or PNG. Max size of 800K</div>
                            </div>
                        </div>

                        
                        <div class="pt-4">
                            <h6 class="mb-4">Personal Information</h6>
                            <div class="row g-5">
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="fullName" name="name" value="<?php echo e(old('name', $user->name)); ?>" required placeholder="Full Name">
                                        <label for="fullName">Full Name <span class="text-danger">*</span></label>
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email" name="email" value="<?php echo e(old('email', $user->email)); ?>" required placeholder="E-mail">
                                        <label for="email">E-mail <span class="text-danger">*</span></label>
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="phone" name="phone" value="<?php echo e(old('phone', $user->phone)); ?>" placeholder="Phone Number">
                                        <label for="phone">Phone Number</label>
                                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="date" class="form-control <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="dateOfBirth" name="date_of_birth" value="<?php echo e(old('date_of_birth', $user->date_of_birth?->format('Y-m-d'))); ?>">
                                        <label for="dateOfBirth">Date of Birth</label>
                                        <?php $__errorArgs = ['date_of_birth'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="pt-4 mt-4 border-top">
                            <h6 class="mb-4">Professional Information</h6>
                            <div class="row g-5">
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control <?php $__errorArgs = ['organization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="organization" name="organization" value="<?php echo e(old('organization', $user->organization)); ?>" placeholder="Organization">
                                        <label for="organization">Organization</label>
                                        <?php $__errorArgs = ['organization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="designation" name="designation" value="<?php echo e(old('designation', $user->designation)); ?>" placeholder="Designation">
                                        <label for="designation">Designation</label>
                                        <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating form-floating-outline">
                                        <input type="text" class="form-control" id="role" value="<?php echo e(ucfirst($user->role ?? 'admin')); ?>" readonly>
                                        <label for="role">Role</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mt-6">
                            <button type="submit" class="btn btn-primary me-3">Save changes</button>
                            <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-outline-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
            <?php endif; ?>

            <?php if($activeTab === 'security'): ?>
            
            <div class="card mb-6">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.profile.password.update')); ?>" method="POST" id="passwordForm">
                        <?php echo csrf_field(); ?>
                        <h5 class="mb-4">Change Password</h5>
                        <div class="row g-5">
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="password" class="form-control <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="currentPassword" name="current_password" required autocomplete="current-password" placeholder="Current Password">
                                    <label for="currentPassword">Current Password <span class="text-danger">*</span></label>
                                    <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-text">
                                    <span class="password-toggle" data-target="currentPassword" style="display: inline-flex; align-items: center; cursor: pointer;">
                                        <i class="ri-eye-off-line me-2"></i>Show password
                                    </span>
                                </div>
                            </div>
                            <div class="col-12"></div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="newPassword" name="password" required autocomplete="new-password" minlength="8" placeholder="New Password">
                                    <label for="newPassword">New Password <span class="text-danger">*</span></label>
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-text">
                                    <span class="password-toggle" data-target="newPassword" style="display: inline-flex; align-items: center; cursor: pointer;">
                                        <i class="ri-eye-off-line me-2"></i>Show password
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating form-floating-outline">
                                    <input type="password" class="form-control" id="confirmPassword" name="password_confirmation" required autocomplete="new-password" minlength="8" placeholder="Confirm Password">
                                    <label for="confirmPassword">Confirm New Password <span class="text-danger">*</span></label>
                                </div>
                                <div class="form-text">
                                    <span class="password-toggle" data-target="confirmPassword" style="display: inline-flex; align-items: center; cursor: pointer;">
                                        <i class="ri-eye-off-line me-2"></i>Show password
                                    </span>
                                </div>
                            </div>
                            <div class="col-12">
                                <h6 class="mb-2">Password Requirements:</h6>
                                <ul class="ps-4 mb-0">
                                    <li class="mb-1">Minimum 8 characters long - the more, the better</li>
                                    <li class="mb-1">At least one lowercase character</li>
                                    <li class="mb-0">At least one number, symbol, or whitespace character</li>
                                </ul>
                            </div>
                        </div>
                        <div class="mt-6">
                            <button type="submit" class="btn btn-primary me-3">Save changes</button>
                            <button type="reset" class="btn btn-outline-secondary">Reset</button>
                        </div>
                    </form>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<script>
(function() {
    var avatarInput = document.getElementById('avatarInput');
    var profileImg = document.getElementById('profileAvatarImg');
    var avatarRemove = document.getElementById('avatarRemove');
    var avatarResetBtn = document.getElementById('avatarResetBtn');

    // Profile photo preview on upload
    if (avatarInput && profileImg) {
        avatarInput.addEventListener('change', function() {
            if (this.files && this.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    profileImg.src = e.target.result;
                };
                reader.readAsDataURL(this.files[0]);
                if (avatarRemove) avatarRemove.value = '0';
            }
        });
    }

    // Reset avatar to default
    if (avatarResetBtn && avatarRemove && profileImg) {
        avatarResetBtn.addEventListener('click', function() {
            profileImg.src = <?php echo json_encode(asset('assets/json/img/avatars/1.png'), 15, 512) ?>;
            avatarRemove.value = '1';
            if (avatarInput) avatarInput.value = '';
        });
    }

    // Password toggle (show/hide)
    document.querySelectorAll('.password-toggle').forEach(function(toggle) {
        toggle.addEventListener('click', function() {
            var targetId = this.getAttribute('data-target');
            var input = document.getElementById(targetId);
            var icon = this.querySelector('i');
            if (!input || !icon) return;
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('ri-eye-off-line');
                icon.classList.add('ri-eye-line');
                this.innerHTML = '<i class="ri-eye-line me-2"></i>Hide password';
            } else {
                input.type = 'password';
                icon.classList.remove('ri-eye-line');
                icon.classList.add('ri-eye-off-line');
                this.innerHTML = '<i class="ri-eye-off-line me-2"></i>Show password';
            }
        });
    });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/contentNavbarLayout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/profile/edit.blade.php ENDPATH**/ ?>