<style>
@media print {
    body { -webkit-print-color-adjust: exact; print-color-adjust: exact; }
    .modal-header, .modal-footer { display: none !important; }
    .modal-body { padding: 0 !important; }
}
.receipt { font-family: system-ui, sans-serif; }
.receipt-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 1rem; margin-bottom: 1.5rem; }
.receipt-title { font-size: 1.5rem; font-weight: 700; text-transform: uppercase; letter-spacing: 0.05em; }
.receipt-meta { font-size: 0.875rem; color: #555; margin-top: 0.5rem; }
.receipt-table { width: 100%; border-collapse: collapse; margin: 1rem 0; }
.receipt-table th, .receipt-table td { padding: 0.5rem 0.75rem; text-align: left; border-bottom: 1px solid #dee2e6; }
.receipt-table th { font-weight: 600; width: 40%; color: #495057; }
.amount-words { font-style: italic; margin-top: 0.5rem; padding: 0.5rem; background: #f8f9fa; border-radius: 0.25rem; }
.receipt-footer { margin-top: 2rem; text-align: center; font-size: 0.8125rem; color: #6c757d; }
</style>

<div class="receipt">
    <div class="receipt-header">
        <div class="receipt-title"><?php echo e(hostel_name()); ?></div>
        <div class="receipt-meta">Rent Receipt</div>
    </div>

    <table class="receipt-table">
        <tr>
            <th>Receipt No.</th>
            <td><?php echo e($rent->receipt_no ?? 'R' . $rent->id); ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <td><?php echo e($rent->paid_at ? $rent->paid_at->format('d/m/Y') : '—'); ?></td>
        </tr>
        <tr>
            <th>Student ID</th>
            <td><?php echo e($rent->student_id); ?></td>
        </tr>
        <tr>
            <th>Student Name</th>
            <td><?php echo e($rent->student->full_name ?? '—'); ?></td>
        </tr>
        <?php if($rent->student && ($rent->student->room_bed_identifier || $rent->student->bed)): ?>
            <tr>
                <th>Room / Bed</th>
                <td><?php echo e($rent->student->room_bed_identifier ?? ($rent->student->bed ? $rent->student->bed->name ?? '—' : '—')); ?></td>
            </tr>
        <?php endif; ?>
        <tr>
            <th>Period</th>
            <td><?php echo e($rent->period_from->format('d/m/Y')); ?> to <?php echo e($rent->period_to->format('d/m/Y')); ?></td>
        </tr>
        <tr>
            <th>Amount (₹)</th>
            <td><?php echo e(number_format($rent->amount, 2)); ?></td>
        </tr>
        <tr>
            <th>Amount in Words</th>
            <td>
                <div class="amount-words"><?php echo e($amountInWords ?? '—'); ?></div>
            </td>
        </tr>
        <tr>
            <th>Payment Mode</th>
            <td><?php echo e(\Illuminate\Support\Arr::get(config('student_registration.payment_modes', []), $rent->payment_mode, $rent->payment_mode)); ?></td>
        </tr>
        <?php if($rent->transaction_id): ?>
            <tr>
                <th>UTR / Transaction ID</th>
                <td><?php echo e($rent->transaction_id); ?></td>
            </tr>
        <?php endif; ?>
        <?php if($rent->cheque_number): ?>
            <tr>
                <th>Cheque Number</th>
                <td><?php echo e($rent->cheque_number); ?></td>
            </tr>
        <?php endif; ?>
    </table>

    <div class="receipt-footer">
        This is a computer-generated receipt. Thank you for your payment.
    </div>
</div>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/GurudevHostel/resources/views/admin/receipts/_rent_content.blade.php ENDPATH**/ ?>